package cn.xisoil.data.pojo.webbasic;

import cn.xisoil.annotation.model.*;
import cn.xisoil.data.enums.ObjectColumnType;
import cn.xisoil.data.enums.ObjectType;
import cn.xisoil.data.pojo.webbasic.font.WebFont;
import cn.xisoil.data.to.StringConverters;
import jakarta.persistence.*;
import jakarta.validation.constraints.NotBlank;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Entity(name = "WebBasic")
@Table(name = "web_basic")
@EntityListeners(AuditingEntityListener.class)
@CurdModelObject(value = "系统参数",edit = false, add = false,
        permission = @PermissionTrusteeShipObject(key = "webBasic",parent = "系统管理"),
        trusteeship = @CurdTrusteeShipObject(type = ObjectType.SINGLE)
)
public class WebBasic {

    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "uuid")
    @Column(columnDefinition = "varchar(32)")
    private String id;

    @OneToMany(cascade = CascadeType.ALL,fetch = FetchType.LAZY)
    @JoinColumn(name = "web_basic_id")
    @CurdModel(value = "字体",type = ObjectColumnType.TABLE,url = "/web/font/columns")
    private Set<WebFont> fonts=new HashSet<>();

    @CurdModel(value = "字号",required = true,type = ObjectColumnType.TEXTAREA)
    private String fontSize;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Set<WebFont> getFonts() {
        return fonts;
    }

    public void setFonts(Set<WebFont> fonts) {
        this.fonts = fonts;
    }

    public String getFontSize() {
        return StringUtils.isBlank(fontSize)?"8pt 10pt 11pt 12pt 13pt 15pt 16pt 17pt 18pt":fontSize;
    }

    public void setFontSize(String fontSize) {
        this.fontSize = fontSize;
    }
}
