package cn.xisoil.data.pojo.dict;


import cn.xisoil.annotation.curd.SelectBy;
import cn.xisoil.annotation.curd.enums.SELECT;
import cn.xisoil.annotation.model.CurdModel;
import cn.xisoil.annotation.model.CurdModelObject;
import cn.xisoil.annotation.model.CurdTrusteeShipObject;
import cn.xisoil.annotation.model.PermissionTrusteeShipObject;
import cn.xisoil.data.enums.ObjectColumnType;
import cn.xisoil.data.enums.ObjectType;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import jakarta.persistence.*;
import org.hibernate.annotations.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

@Entity(name = "DictType")
@Table(name = "dict_type")
@EntityListeners(AuditingEntityListener.class)
@CurdModelObject(value = "字典分类",
        permission = @PermissionTrusteeShipObject(key = "",parent = "数据字典"))
public class DictType {



    @Id
    @CurdModel(value = "分类标识",search = true,required = true,editor = false)
    private String id;


    @CurdModel(value = "分类名称")
    private String title;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }


}
