package cn.xisoil.data.pojo.basic;

import cn.xisoil.annotation.model.*;
import cn.xisoil.data.enums.ObjectColumnType;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.persistence.*;
import jakarta.validation.constraints.NotBlank;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity(name = "BasicData")
@Table(name = "basic_data")
@EntityListeners(AuditingEntityListener.class)
@CurdModelObject(value = "系统配置", edit = false, add = false)
public class BasicData {

    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "uuid")
    @Column(columnDefinition = "varchar(32)")
    private String id;

    @CurdModel(value = "网站名称",required = true)
    @NotBlank(message = "网站名称不能为空")
    private String name;

    @CurdModel(value = "网站简称")
    private String shortName;

    @CurdModel(value = "开启注册",type = ObjectColumnType.BOOLEAN)
    @JsonProperty("isRegister")
    private Boolean isRegister;

    @CurdModel(value = "开启日志",type = ObjectColumnType.BOOLEAN)
    @JsonProperty("isLog")
    private Boolean isLog=false;

    @CurdModel(value = "默认角色",type = ObjectColumnType.LIST,url = "/role/list")
    private String roleId;

    @CurdModel(value = "网站logo",type = ObjectColumnType.IMAGE)
    private String logo;

    @CurdModel(value = "网站ICO",type = ObjectColumnType.IMAGE)
    private String ico;

    @CurdModel(value = "微信回调")
    private String wxNotifyUrl;

    @CurdModel(value = "通知地址")
    private String socketIo;

    @CurdModel(value = "邮箱服务器")
    private String emailSmtp;
    @CurdModel(value = "邮箱账号")
    private String emailAccount;
    @CurdModel(value = "邮箱密码")
    private String emailPassword;

    @CurdModel(value = "服务条款",type = ObjectColumnType.EDITOR)
    @Lob
    private String teamOfService;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        return shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public Boolean getRegister() {
        return isRegister;
    }

    public void setRegister(Boolean register) {
        isRegister = register;
    }

    public Boolean getLog() {
        return isLog;
    }

    public void setLog(Boolean log) {
        isLog = log;
    }

    public String getRoleId() {
        return roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getIco() {
        return ico;
    }

    public void setIco(String ico) {
        this.ico = ico;
    }

    public String getWxNotifyUrl() {
        return wxNotifyUrl;
    }

    public void setWxNotifyUrl(String wxNotifyUrl) {
        this.wxNotifyUrl = wxNotifyUrl;
    }

    public String getSocketIo() {
        return socketIo;
    }

    public void setSocketIo(String socketIo) {
        this.socketIo = socketIo;
    }

    public String getEmailSmtp() {
        return emailSmtp;
    }

    public void setEmailSmtp(String emailSmtp) {
        this.emailSmtp = emailSmtp;
    }

    public String getEmailAccount() {
        return emailAccount;
    }

    public void setEmailAccount(String emailAccount) {
        this.emailAccount = emailAccount;
    }

    public String getEmailPassword() {
        return emailPassword;
    }

    public void setEmailPassword(String emailPassword) {
        this.emailPassword = emailPassword;
    }

    public String getTeamOfService() {
        return teamOfService;
    }

    public void setTeamOfService(String teamOfService) {
        this.teamOfService = teamOfService;
    }
}
