package cn.xisoil.data.enums;

public enum HTTPCODE {

    SUCCESS(200,"请求成功"),//正常处理
    RESTCONTENT(205,"请求成功，正在刷新视图"),//刷新当前页面
    MULTISTATUS(207,"请求成功"),//提示返回内容
    BADREQUEST(400,"请求格式错误"),//错误提示，无需其他操作
    ACCEPTED(202,"请求成功,暂未处理"),//接受请求，未处理
    NOTFOUND(404,"资源丢失"),//错误提示，无需其他操作
    ERROR(500,"服务器错误"),//错误提示，无需其他操作
    UNAUTHORIZED(401,"客户端验证失败"),//警告提示，跳转登录页
    FORBIDDEN(403,"客户端没有权限访问");//警告无权限


    private final Integer code;
    private final String message;

    HTTPCODE(Integer code, String message){
        this.code=code;
        this.message=message;
    }
    public Integer getCode() {
        return code;
    }
    public String getMessage() {
        return message;
    }


    @Override
    public String toString() {
        return message;
    }
}
