package cn.xisoil.controller.webbasic;

import cn.xisoil.annotation.log.Log;
import cn.xisoil.dao.webbasic.WebBasicRepository;
import cn.xisoil.data.pojo.webbasic.WebBasic;
import cn.xisoil.data.result.R;
import cn.xisoil.model.controller.SingleModelController;
import jakarta.validation.Valid;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping("/manage/webbasic")
@RestController("WebBasicController")
public class WebBasicController extends SingleModelController<WebBasic, WebBasicRepository> {
  @Log("获取系统参数详情")
  @GetMapping("")
  public R get() {
    return super.get();
  }

  @PutMapping("")
  @Log("修改系统参数")
  public R edit(@Valid @RequestBody WebBasic request, BindingResult result) {
    return super.edit(request);
  }
}
