package cn.xisoil.controller.user;


import cn.xisoil.dao.user.UserRepository;
import cn.xisoil.data.pojo.user.LoginUser;
import cn.xisoil.data.result.R;
import cn.xisoil.model.controller.ModelCurdControllerMapping;
import cn.xisoil.service.user.UserService;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/manage/user")
public class UserController extends ModelCurdControllerMapping<LoginUser, UserRepository> {

    @Autowired
    private UserService userService;

    @PutMapping("")
    @Primary
    public R<String> edit(@Valid @RequestBody LoginUser request, BindingResult result){
        if (result.hasErrors()){
            for (ObjectError error : result.getAllErrors()) {
                return R.<String>builder().fail().code(500).message(error.getDefaultMessage()).build();
            }
        }
        return userService.edit(request);
    }

    @PostMapping("")
    @Primary
    protected R<String> add(@Valid @RequestBody LoginUser request, BindingResult result){
        if (result.hasErrors()){
            for (ObjectError error : result.getAllErrors()) {
                return R.<String>builder().fail().code(500).message(error.getDefaultMessage()).build();
            }
        }
        return userService.add(request);
    }


    @Override
    public String getUrl() {
        return "/user";
    }

    @Override
    public String getName() {
        return "用户列表";
    }

    @Override
    public String getParent() {
        return "用户管理";
    }

    @Override
    public boolean auto() {
        return true;
    }


}
