package cn.xisoil.controller.login;



import cn.xisoil.annotation.log.LoginLog;
import cn.xisoil.dao.user.UserRepository;
import cn.xisoil.data.dto.login.EditUserRequest;
import cn.xisoil.data.dto.login.LoginDto;
import cn.xisoil.data.dto.login.LoginRequest;
import cn.xisoil.data.pojo.user.LoginUser;
import cn.xisoil.data.result.R;
import cn.xisoil.exception.ResponseException;
import cn.xisoil.model.controller.SingleModelController;
import cn.xisoil.service.login.LoginService;
import jakarta.validation.Valid;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping(value = "/manage/auth")
public class LoginController extends SingleModelController<LoginUser, UserRepository> {

    @Autowired
    private LoginService loginService;

    @PostMapping("/login")
    @LoginLog
    public R<LoginDto> userLogin(@Valid @RequestBody LoginRequest request, BindingResult result){
        if (result.hasErrors()){
            for (ObjectError error : result.getAllErrors()) {
                throw new ResponseException(500,error.getDefaultMessage());
            }
        }
        return loginService.userLogin(request);
    }

    @GetMapping({"","/userInfo"})
    @Primary
    public R<LoginUser> get(){
        return loginService.getUserInfo();
    }


    @PutMapping("")
    @Primary
    public R<String> edit(@Valid @RequestBody LoginUser request, BindingResult result){
        EditUserRequest user=new EditUserRequest();
        BeanUtils.copyProperties(request,user);
        return loginService.edit(user);
    }






}
