package cn.xisoil.asp.filter;

import cn.xisoil.annotation.filter.IgnorePackageAdvice;
import cn.xisoil.data.result.R;
import com.alibaba.fastjson2.JSONObject;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

/**
 * @Description RestController统一拦截处理，强制包装R返回值，@IgnorePackageAdvice过滤拦截
 * @Author Vien
 * @CreateTime 2023-03-2023/3/21 15:15:13
 **/

@RestControllerAdvice
public class ResponseAdvice implements ResponseBodyAdvice<Object> {

    @Override
    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return !returnType.hasMethodAnnotation(IgnorePackageAdvice.class)
                &&
                returnType.getDeclaringClass().getAnnotation(IgnorePackageAdvice.class)==null;
    }

    @Override
    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (body instanceof R<?>){
            return body;
        }
        if (returnType.getParameterType().isAssignableFrom(String.class)) {
            return JSONObject.toJSONString(R.ok(body));
        }
        return R.ok(body);
    }
}
