package cn.xisoil.model.controller;

import cn.xisoil.annotation.permission.PermissionCheckAutomation;
import cn.xisoil.dao.utils.YueRepository;
import cn.xisoil.data.enums.ObjectType;
import cn.xisoil.data.result.R;
import cn.xisoil.model.data.ModelClass;
import cn.xisoil.model.data.ModelColumn;
import cn.xisoil.model.service.model.ModelService;
import cn.xisoil.model.service.single.SingleDaoServiceImpl;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class SingleModelController<T,V extends YueRepository<T,String>> extends SingleDaoServiceImpl<T, V> implements PermissionCheckAutomation<T> {

    @Autowired
    private ModelService modelService;

    @GetMapping("/columns")
    public R<ModelClass> columns() {
        ModelClass yueModelClass= modelService.getModelClass(super.getGenericClass());
        yueModelClass.setType(ObjectType.SINGLE);
        List<ModelColumn>columns= modelService.getModelColumns(super.getGenericClass());
        Map<String,List<ModelColumn>> groups=columns.stream().collect(Collectors.groupingBy(ModelColumn::getGroup));
        yueModelClass.setColumns(columns);
        yueModelClass.setGroups(groups);
        return R.<ModelClass>builder().data(yueModelClass).success().message("获取成功").build();
    }

    @GetMapping("")
    public R<T> get(){
        return super.get();
    }

    @PutMapping("")
    public R<String> edit(@Valid  @RequestBody T r, BindingResult result){
        if (result.hasErrors()){
            for (ObjectError error : result.getAllErrors()) {
                return R.<String>builder().fail().code(500).message(error.getDefaultMessage()).build();
            }
        }
        return super.edit(r);
    }

}
