package cn.xisoil.model.controller;

import cn.xisoil.annotation.permission.PermissionCheckAutomation;
import cn.xisoil.dao.utils.YueRepository;
import cn.xisoil.data.result.R;
import cn.xisoil.data.to.ListStringRequest;
import cn.xisoil.data.to.SearchPageRequest;
import cn.xisoil.data.to.SearchSoRequest;
import cn.xisoil.model.data.ModelClass;
import cn.xisoil.model.data.ModelColumn;
import cn.xisoil.data.enums.ObjectType;
import cn.xisoil.model.service.list.CurdDaoServiceImpl;
import cn.xisoil.model.service.model.ModelService;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


public abstract class ModelCurdControllerMapping<T,V extends YueRepository<T,String>> extends CurdDaoServiceImpl<T,V> implements PermissionCheckAutomation<T> {

    @Autowired
    private ModelService modelService;

    @GetMapping("/columns")
    public R<ModelClass> columns() {
        ModelClass yueModelClass= modelService.getModelClass(super.getGenericClass());
        List<ModelColumn>columns= modelService.getModelColumns(super.getGenericClass());
        Map<String,List<ModelColumn>> groups=columns.stream().collect(Collectors.groupingBy(ModelColumn::getGroup));
        yueModelClass.setColumns(columns);
        yueModelClass.setGroups(groups);
        yueModelClass.setType(ObjectType.LIST);
        return R.<ModelClass>builder().data(yueModelClass).success().message("获取成功").build();
    }

    @PostMapping("/page")
    public R<Page<T>> page(@Valid @RequestBody SearchPageRequest searchPageRequest, BindingResult result) {
        if (result.hasErrors()){
            for (ObjectError error : result.getAllErrors()) {
                return R.<Page<T>>builder().fail().code(500).message(error.getDefaultMessage()).build();
            }
        }
        return super.page(searchPageRequest);
    }

    @GetMapping("/list")
    public R<List<T>> list() {
        return super.list();
    }

    @PostMapping("/search")
    public R<List<T>> search(
            @RequestBody SearchSoRequest searchSoRequest

    ) {
        return super.search(searchSoRequest);
    }

    @PostMapping("/delete")
    protected R<String> delete(@Valid @RequestBody ListStringRequest stringRequest, BindingResult result){
        if (result.hasErrors()){
            for (ObjectError error : result.getAllErrors()) {
                return R.<String>builder().fail().code(500).message(error.getDefaultMessage()).build();
            }
        }
        return  super.delete(stringRequest);
    }

    @PutMapping("")
    public R<String> edit(@Valid @RequestBody T request, BindingResult result){
        if (result.hasErrors()){
            for (ObjectError error : result.getAllErrors()) {
                return R.<String>builder().fail().code(500).message(error.getDefaultMessage()).build();
            }
        }
        return super.edit(request);
    }

    @PostMapping("")
    protected R<String> add(@Valid @RequestBody T request, BindingResult result){
        if (result.hasErrors()){
            for (ObjectError error : result.getAllErrors()) {
                return R.<String>builder().fail().code(500).message(error.getDefaultMessage()).build();
            }
        }
        return super.add(request);
    }

    @GetMapping("/{id}")
    public R<T> get(@PathVariable String id){
        return super.get(id);
    }

}
