package cn.xisoil.exception.advice;

import cn.xisoil.exception.ErrorPageException;
import cn.xisoil.exception.RefusedException;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

import jakarta.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@ControllerAdvice
public class YueExceptionController {

    @ExceptionHandler(RefusedException.class)
    public String IpRefused(HttpServletRequest request, Throwable ex, Model model) {
        model.addAttribute("message",ex.getMessage());
        return "dist/error/ipError.html";//封装异常信息
    }

    @ExceptionHandler(ErrorPageException.class)
    public String errorPage(HttpServletRequest request, Throwable ex, Model model) {
        HttpServletResponse response = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getResponse();
        response.setStatus(getStatus(request).value());
        model.addAttribute("message",ex.getMessage());
        return "dist/error/errorpage.html";//封装异常信息
    }

    private HttpStatus getStatus(HttpServletRequest request) {
        Integer statusCode = (Integer) request.getAttribute("jakarta.servlet.error.status_code");
        if (statusCode == null) {
            return HttpStatus.INTERNAL_SERVER_ERROR;
        }
        return HttpStatus.valueOf(statusCode);
    }

}
