package cn.xisoil.data.pojo.user;

import cn.xisoil.annotation.model.CurdModel;
import cn.xisoil.annotation.model.CurdModelObject;
import cn.xisoil.data.enums.ObjectColumnType;
import jakarta.persistence.*;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import java.math.BigDecimal;
import java.util.Date;

@Entity(name = "User")
@Table(name = "User")
@CurdModelObject(value = "用户管理")
@EntityListeners(AuditingEntityListener.class)
public class LoginUser {

    public LoginUser(){

    }
    public LoginUser(String name){
        this.nickname=name;
        this.account=name;
    }

    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy = "uuid")
    @Column(columnDefinition = "varchar(32)")
    private String id;

    @CurdModel(value = "账号",search = true)
    private String account;

    @CurdModel(value = "加密密码",required = true)
    private String password="";

    @CurdModel(value = "昵称")
    private String nickname;

    @CurdModel(value = "排序",type = ObjectColumnType.NUMBER,comparable = true)
    private Integer comparable;

    @CreatedDate
    private Date createTime;

    @CurdModel(value = "所属角色",type = ObjectColumnType.LIST,url = "/role/list",search = true)
    private String roleId;

    @CurdModel(value = "头像",type = ObjectColumnType.IMAGE,show = false)
    private String headImage;

    private String title;

    public String getTitle() {
        return nickname;
    }//这里需要后续修改，自定义title

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public Integer getComparable() {
        return comparable;
    }

    public void setComparable(Integer comparable) {
        this.comparable = comparable;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getRoleId() {
        return roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public String getHeadImage() {
        return headImage;
    }

    public void setHeadImage(String headImage) {
        this.headImage = headImage;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}
