package cn.xisoil.data.pojo.log;


import cn.xisoil.annotation.model.CurdModel;
import cn.xisoil.annotation.model.CurdModelObject;
import cn.xisoil.data.enums.ObjectColumnType;
import jakarta.persistence.*;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import java.util.Date;

@Entity(name = "LoginLog")
@Table(name = "v_login_log")
@EntityListeners(AuditingEntityListener.class)
@CurdModelObject(value = "登录日志",edit = false,add = false)
public class LoginLog {

    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy = "uuid")
    @Column(columnDefinition = "varchar(32)")
    private String id;

    @CurdModel(value = "登录账号",search = true)
    private String account;

    @CurdModel(value = "登录时间",type = ObjectColumnType.TIME,comparable = true)
    @CreatedDate
    private Date createTime;

    @CurdModel(value = "状态码")
    private Integer code;

    @CurdModel(value = "是否成功",type = ObjectColumnType.BOOLEAN)
    private Boolean isSuccess;

    @CurdModel(value = "登录IP")
    private String ip;

    @CurdModel(value = "返回信息",type = ObjectColumnType.TEXTAREA)
    private String message;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public Boolean getSuccess() {
        return isSuccess;
    }

    public void setSuccess(Boolean success) {
        isSuccess = success;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
