package cn.xisoil.data.pojo.dict;


import cn.xisoil.annotation.curd.SelectBy;
import cn.xisoil.annotation.curd.enums.SELECT;
import cn.xisoil.annotation.model.CurdModel;
import cn.xisoil.annotation.model.CurdModelObject;
import cn.xisoil.annotation.model.CurdTrusteeShipObject;
import cn.xisoil.annotation.model.PermissionTrusteeShipObject;
import cn.xisoil.data.enums.ObjectColumnType;
import cn.xisoil.data.enums.ObjectType;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import jakarta.persistence.*;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

@Entity(name = "Dict")
@Table(name = "dict")
@EntityListeners(AuditingEntityListener.class)
@CurdModelObject(value = "字典管理",
        permission = @PermissionTrusteeShipObject(key = "",parent = "数据字典"))
public class Dict {


    @Id
    @Column(columnDefinition = "varchar(32)")
    @CurdModel(value = "字典键",search = true,required = true)
    private String id;

    @CurdModel(value = "字典值",search = true,required = true)
    private String title;

    @CurdModel(value = "是否可用",type = ObjectColumnType.BOOLEAN,search = true,required = true)
    private Boolean available=true;

    @CurdModel(value = "所属分类",search = true,url = "/dicttype/list",type = ObjectColumnType.LIST,required = true)
    @Column(columnDefinition = "varchar(32)")
    private String type;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Boolean getAvailable() {
        return available;
    }

    public void setAvailable(Boolean available) {
        this.available = available;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
}
