package cn.xisoil.controller.permission;

import cn.xisoil.dao.permission.PermissionRepository;
import cn.xisoil.data.pojo.permission.Permission;
import cn.xisoil.data.result.R;
import cn.xisoil.data.to.SearchPageRequest;
import cn.xisoil.model.controller.ModelCurdControllerMapping;
import cn.xisoil.service.permission.YuePermissionService;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.data.domain.Page;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/manage/permission")
public class PermissionController extends ModelCurdControllerMapping<Permission, PermissionRepository> {

    @Autowired
    private YuePermissionService yuePermissionService;

    @GetMapping("/list")
    @Primary
    public R<List<Permission>> list() {
        return yuePermissionService.list();
    }

    @PostMapping("/page")
    @Primary
    public R<Page<Permission>> page(@Valid @RequestBody SearchPageRequest searchPageRequest, BindingResult result) {
        if (result.hasErrors()){
            for (ObjectError error : result.getAllErrors()) {
                return R.<Page<Permission>>builder().fail().code(500).message(error.getDefaultMessage()).build();
            }
        }
        return super.page(searchPageRequest);
    }


    @Override
    public String getUrl() {
        return "/permission";
    }

    @Override
    public String getName() {
        return "权限管理";
    }

    @Override
    public String getParent() {
        return "用户管理";
    }
}
