package cn.xisoil.controller.dict;

import cn.xisoil.dao.dict.DictRepository;
import cn.xisoil.dao.log.LoginLogRepository;
import cn.xisoil.data.pojo.dict.Dict;
import cn.xisoil.data.result.R;
import cn.xisoil.model.controller.ModelCurdControllerMapping;
import cn.xisoil.service.dict.DictService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description TODO
 * @Author Vien
 * @CreateTime 2023-05-2023/5/19 09:13:59
 **/
@RequestMapping("/manage/dict")
@RestController
public class DictController  extends ModelCurdControllerMapping<Dict, DictRepository> {

    @Autowired
    private DictService dictService;


    @Override
    public String getUrl() {
        return "/dict";
    }

    @Override
    public boolean auto() {
        return true;
    }

    @Override
    public String getName() {
        return "字典管理";
    }

    @Override
    public String getParent() {
        return "数据字典";
    }

    @GetMapping("/list/{key}")
    public R list(@PathVariable String key){
        return dictService.list(key);
    }

}
