package cn.xisoil.controller.basic;

import cn.xisoil.dao.basic.BasicDataRepository;
import cn.xisoil.data.pojo.basic.BasicData;
import cn.xisoil.data.result.R;
import cn.xisoil.model.controller.SingleModelController;
import cn.xisoil.service.basic.BasicDataService;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/manage/system/basic")
public class BasicDataController extends SingleModelController<BasicData, BasicDataRepository> {

    @Override
    public String getUrl() {
        return "/system/basic";
    }

    @Override
    public String getName() {
        return "系统配置";
    }

    @Override
    public String getParent() {
        return "系统管理";
    }

    @Autowired
    private BasicDataService yueBasicDataService;

    @GetMapping()
    @Primary
    public R<BasicData> get(){
        return yueBasicDataService.get();
    }

    @PutMapping()
    @Primary
    public R<String> edit(@Valid  @RequestBody BasicData yueBasicData, BindingResult result){
        if (result.hasErrors()){
            for (ObjectError error : result.getAllErrors()) {
                return R.<String>builder().fail().code(500).message(error.getDefaultMessage()).build();
            }
        }
        return yueBasicDataService.edit(yueBasicData);
    }


}
