/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.utils.processor;

import cn.xisoil.utils.EnableXisoil;
import com.google.auto.service.AutoService;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

@AutoService(value={Processor.class})
public class AutoScanProcessor
extends AbstractProcessor {
    private Elements elementTool;
    private Messager messager;
    private Filer filer;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        this.elementTool = processingEnv.getElementUtils();
        this.messager = processingEnv.getMessager();
        this.filer = processingEnv.getFiler();
        super.init(processingEnv);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> set = new HashSet<String>();
        set.add(EnableXisoil.class.getCanonicalName());
        return set;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!annotations.isEmpty()) {
            Set<? extends Element> bindElement = roundEnv.getElementsAnnotatedWith(EnableXisoil.class);
            try {
                this.generateCode(bindElement);
            }
            catch (IOException | ClassNotFoundException e) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, e.toString());
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private void generateCode(Set<? extends Element> elements) throws IOException, ClassNotFoundException {
        for (Element element : elements) {
            SpringBootApplication springBootApplication = element.getAnnotation(SpringBootApplication.class);
            String[] scanBasePackages = springBootApplication.scanBasePackages();
            StringBuffer packages = new StringBuffer("{\"cn.xisoil.*\",\"");
            for (int i = 0; i < scanBasePackages.length; ++i) {
                packages.append(scanBasePackages[i]).append("\"");
                if (i == scanBasePackages.length - 1) continue;
                packages.append(",\"");
            }
            packages.append("}");
            AnnotationSpec enableJpaRepositories = AnnotationSpec.builder(EnableJpaRepositories.class).addMember("value", "$L", new Object[]{packages}).build();
            AnnotationSpec entityScan = AnnotationSpec.builder(EntityScan.class).addMember("value", "$L", new Object[]{packages}).build();
            AnnotationSpec configuration = AnnotationSpec.builder(Configuration.class).build();
            AnnotationSpec componentScan = AnnotationSpec.builder(ComponentScan.class).addMember("value", "$L", new Object[]{packages}).build();
            TypeSpec type = TypeSpec.classBuilder((String)"ModelConfig").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(enableJpaRepositories).addAnnotation(entityScan).addAnnotation(componentScan).addAnnotation(configuration).build();
            JavaFile.builder((String)"cn.xisoil.utils", (TypeSpec)type).build().writeTo(this.filer);
        }
    }
}

