/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.utils.processor;

import cn.xisoil.annotation.model.CurdModelObject;
import cn.xisoil.annotation.model.CurdTrusteeShipObject;
import cn.xisoil.dao.utils.YueRepository;
import cn.xisoil.data.enums.ObjectType;
import cn.xisoil.model.controller.ModelCurdController;
import cn.xisoil.model.controller.SingleModelController;
import cn.xisoil.model.utils.ConfigProperties;
import cn.xisoil.model.utils.JavaPoetAutoGenerate;
import com.google.auto.service.AutoService;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import org.apache.commons.lang3.StringUtils;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.JavaFile;
import org.springframework.javapoet.ParameterizedTypeName;
import org.springframework.javapoet.TypeName;
import org.springframework.javapoet.TypeSpec;

@AutoService(value={Processor.class})
public class AutoControllerProcessor
extends AbstractProcessor {
    private Elements elementTool;
    private Messager messager;
    private Filer filer;
    public static String CONTROLLER = "Controller";
    public static String REPOSITORY = "Repository";
    public static String TARGET = "target/classes/";
    public static String SRC = "src/main/java/";
    public static String BASEMAPPING = "/manage";
    private final String fileDir = this.getClass().getResource("/").getPath().replace(TARGET, SRC);
    private String persistentDir;
    private String controllerDir;
    private final ConfigProperties configProperties = new ConfigProperties();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        this.elementTool = processingEnv.getElementUtils();
        this.messager = processingEnv.getMessager();
        this.filer = processingEnv.getFiler();
        this.persistentDir = this.fileDir + this.configProperties.persistent.replace(".", "/");
        this.controllerDir = this.fileDir + this.configProperties.controller.replace(".", "/");
        super.init(processingEnv);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> set = new HashSet<String>();
        set.add(CurdModelObject.class.getCanonicalName());
        return set;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!annotations.isEmpty()) {
            Set<? extends Element> bindElement = roundEnv.getElementsAnnotatedWith(CurdModelObject.class);
            try {
                this.generateCode(bindElement);
            }
            catch (IOException | ClassNotFoundException e) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, e.toString());
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private void generateCode(Set<? extends Element> elements) throws IOException, ClassNotFoundException {
        for (Element element : elements) {
            CurdModelObject curdModelObject = element.getAnnotation(CurdModelObject.class);
            CurdTrusteeShipObject curdTrusteeShipObject = curdModelObject.trusteeship();
            JavaPoetAutoGenerate javaPoetAutoGenerate = new JavaPoetAutoGenerate(curdModelObject);
            TypeElement typeElement = (TypeElement)element;
            String QualifiedName = typeElement.getQualifiedName().toString();
            PackageElement packageElement = this.elementTool.getPackageOf(typeElement);
            String packageName = packageElement.getQualifiedName().toString();
            String className = AutoControllerProcessor.getClassName(typeElement, packageName);
            String lowerClassName = className.toLowerCase();
            File file = new File(this.fileDir);
            if (!curdTrusteeShipObject.auto()) continue;
            String persistent = String.format("%s.%s", this.configProperties.persistent, lowerClassName);
            String persistentClass = String.format("%s%s", className, REPOSITORY);
            String controller = String.format("%s.%s", this.configProperties.controller, lowerClassName);
            String controllerClass = String.format("%s%s", className, CONTROLLER);
            String controllerManageMapping = String.format("%s%s", BASEMAPPING, StringUtils.isNotBlank((CharSequence)curdTrusteeShipObject.router()) ? curdTrusteeShipObject.router() : "/" + lowerClassName);
            if (!new File(this.persistentDir + "/" + lowerClassName + "/" + persistentClass + ".java").exists()) {
                TypeSpec persistentType = TypeSpec.interfaceBuilder((String)persistentClass).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(YueRepository.class), (TypeName[])new TypeName[]{ClassName.get((String)packageName, (String)className, (String[])new String[0]), ClassName.get((String)"java.lang", (String)"String", (String[])new String[0])})).build();
                JavaFile.builder((String)persistent, (TypeSpec)persistentType).build().writeTo(file);
            }
            if (new File(this.controllerDir + "/" + lowerClassName + "/" + controllerClass + ".java").exists()) continue;
            ObjectType objectType = curdTrusteeShipObject.type();
            Class ModelCurdControllerMapping2 = objectType.equals((Object)ObjectType.LIST) ? ModelCurdController.class : SingleModelController.class;
            TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)controllerClass).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(ModelCurdControllerMapping2), (TypeName[])new TypeName[]{ClassName.get((String)packageName, (String)className, (String[])new String[0]), ClassName.get((String)persistent, (String)persistentClass, (String[])new String[0])})).addAnnotation(javaPoetAutoGenerate.requestMappingAnnotationSpec(controllerManageMapping)).addAnnotation(javaPoetAutoGenerate.restControllerAnnotationSpec(controllerClass));
            if (ModelCurdControllerMapping2.equals(ModelCurdController.class)) {
                typeBuilder.addMethod(javaPoetAutoGenerate.delMethSpec()).addMethod(javaPoetAutoGenerate.addMethSpec((TypeName)ClassName.get((String)packageName, (String)className, (String[])new String[0]))).addMethod(javaPoetAutoGenerate.pageMethSpec()).addMethod(javaPoetAutoGenerate.editMethSpec((TypeName)ClassName.get((String)packageName, (String)className, (String[])new String[0]))).addMethod(javaPoetAutoGenerate.getMethSpec((Type)((Object)String.class)));
            } else {
                typeBuilder.addMethod(javaPoetAutoGenerate.getMethSpec()).addMethod(javaPoetAutoGenerate.editMethSpec((TypeName)ClassName.get((String)packageName, (String)className, (String[])new String[0])));
            }
            JavaFile.builder((String)controller, (TypeSpec)typeBuilder.build()).build().writeTo(file);
        }
    }

    private static String getClassName(TypeElement type, String packageName) {
        int packageLen = packageName.length() + 1;
        return type.getQualifiedName().toString().substring(packageLen).replace('.', '$');
    }
}

