/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.service.user.impl;

import cn.xisoil.config.token.JwtUtils;
import cn.xisoil.dao.user.UserRepository;
import cn.xisoil.data.pojo.user.LoginUser;
import cn.xisoil.data.result.R;
import cn.xisoil.data.to.SearchPageRequest;
import cn.xisoil.service.user.UserService;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl
implements UserService {
    @Autowired
    private JwtUtils jwtUtils;
    @Autowired
    private UserRepository userRepository;

    @Override
    public R<Page<LoginUser>> page(SearchPageRequest searchPageRequest) {
        LoginUser user = this.jwtUtils.getLoginUser();
        PageRequest pageable = PageRequest.of((int)searchPageRequest.getPageNum(), (int)searchPageRequest.getPageSize());
        Specification & Serializable sectionSpecification = (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (StringUtils.isNotBlank((CharSequence)searchPageRequest.getKeyword())) {
                predicates.add(criteriaBuilder.like((Expression)root.get("account"), "%" + searchPageRequest.getKeyword() + "%"));
            }
            if (searchPageRequest.getOrderBy() != null) {
                criteriaQuery.orderBy(new Order[]{searchPageRequest.getOrderBy().getSortType().equals((Object)Sort.Direction.DESC) ? criteriaBuilder.desc((Expression)root.get(searchPageRequest.getOrderBy().getColumn())) : criteriaBuilder.asc((Expression)root.get(searchPageRequest.getOrderBy().getColumn()))});
            }
            return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        };
        Page page = this.userRepository.findAll(sectionSpecification, (Pageable)pageable);
        return R.builder().message("\u83b7\u53d6\u6210\u529f").success().data(page).build();
    }

    @Override
    public R<String> edit(LoginUser request) {
        LoginUser user = this.userRepository.findById(request.getId()).orElse(new LoginUser());
        if (!user.getPassword().equals(request.getPassword())) {
            BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
            String encode = passwordEncoder.encode((CharSequence)request.getPassword());
            request.setPassword(encode);
        }
        BeanUtils.copyProperties((Object)request, (Object)user);
        this.userRepository.save(user);
        return R.builder().success().message("\u4fee\u6539\u6210\u529f").build();
    }

    @Override
    public R<String> add(LoginUser request) {
        LoginUser user = new LoginUser();
        BeanUtils.copyProperties((Object)request, (Object)user);
        BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
        String encode = passwordEncoder.encode((CharSequence)request.getPassword());
        user.setPassword(encode);
        this.userRepository.save(user);
        return R.builder().success().message("\u4fee\u6539\u6210\u529f").build();
    }
}

