/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.service.permission.impl;

import cn.xisoil.dao.permission.PermissionRepository;
import cn.xisoil.data.pojo.permission.Permission;
import cn.xisoil.data.result.R;
import cn.xisoil.data.to.SearchPageRequest;
import cn.xisoil.service.permission.YuePermissionService;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class YuePermissionServiceImpl
implements YuePermissionService {
    @Autowired
    private PermissionRepository permissionRepository;

    @Override
    public R<List<Permission>> list() {
        List<Permission> permissions = this.permissionRepository.findAllByParentIdIsNull();
        return R.builder().success().data(permissions).build();
    }

    @Override
    public R<Page<Permission>> page(SearchPageRequest searchPageRequest) {
        PageRequest pageable = PageRequest.of((int)searchPageRequest.getPageNum(), (int)searchPageRequest.getPageSize());
        Specification & Serializable sectionSpecification = (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (StringUtils.isNotBlank((CharSequence)searchPageRequest.getKeyword())) {
                predicates.add(criteriaBuilder.like((Expression)root.get("name"), "%" + searchPageRequest.getKeyword() + "%"));
            }
            if (StringUtils.isNotBlank((CharSequence)searchPageRequest.getString("parentId"))) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("parentId"), searchPageRequest.get("parentId")));
            }
            if (StringUtils.isBlank((CharSequence)searchPageRequest.getKeyword()) && StringUtils.isBlank((CharSequence)searchPageRequest.getString("parentId"))) {
                predicates.add(root.get("parentId").isNull());
            }
            if (searchPageRequest.getOrderBy() != null) {
                criteriaQuery.orderBy(new Order[]{searchPageRequest.getOrderBy().getSortType().equals((Object)Sort.Direction.DESC) ? criteriaBuilder.desc((Expression)root.get(searchPageRequest.getOrderBy().getColumn())) : criteriaBuilder.asc((Expression)root.get(searchPageRequest.getOrderBy().getColumn()))});
            }
            return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        };
        Page page = this.permissionRepository.findAll(sectionSpecification, (Pageable)pageable);
        return R.builder().data(page).success().build();
    }
}

