/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.service.login.impl;

import cn.xisoil.config.token.JwtUtils;
import cn.xisoil.dao.user.UserRepository;
import cn.xisoil.data.dto.login.EditUserRequest;
import cn.xisoil.data.dto.login.LoginDto;
import cn.xisoil.data.dto.login.LoginRequest;
import cn.xisoil.data.enums.HTTPCODE;
import cn.xisoil.data.pojo.user.LoginUser;
import cn.xisoil.data.result.R;
import cn.xisoil.exception.ResponseException;
import cn.xisoil.service.login.LoginPermissionUtils;
import cn.xisoil.service.login.LoginService;
import jakarta.transaction.Transactional;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class LoginServiceImpl
implements LoginService {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private JwtUtils jwtUtils;
    @Autowired
    private LoginPermissionUtils loginPermissionUtils;

    @Override
    @Transactional
    public R<LoginDto> userLogin(LoginRequest request) {
        LoginUser user = this.userRepository.findOneByAccount(request.getAccount()).orElseThrow(() -> new ResponseException(403, "\u8d26\u53f7\u4e0d\u5b58\u5728"));
        this.userRepository.save(user);
        if (!new BCryptPasswordEncoder().matches((CharSequence)request.getPassword(), user.getPassword())) {
            throw new ResponseException(403, "\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef");
        }
        String token = this.jwtUtils.jwt(user);
        LoginDto loginDto = new LoginDto();
        loginDto.setToken(token);
        loginDto.setUser(user);
        loginDto.setPermissions(this.loginPermissionUtils.structureByRoleId(user.getRoleId()));
        return R.builder().result(HTTPCODE.SUCCESS).message("\u767b\u5f55\u6210\u529f").data(loginDto).build();
    }

    @Override
    public R<LoginUser> getUserInfo() {
        LoginUser user = this.jwtUtils.getLoginUser();
        return R.builder().success().message("\u83b7\u53d6\u6210\u529f").data((LoginUser)this.userRepository.findById(user.getId()).get()).build();
    }

    @Override
    public R<String> edit(EditUserRequest request) {
        LoginUser user = this.jwtUtils.getLoginUser();
        if (!user.getPassword().equals(request.getPassword())) {
            BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
            String encode = passwordEncoder.encode((CharSequence)request.getPassword());
            request.setPassword(encode);
        }
        BeanUtils.copyProperties((Object)request, (Object)user);
        this.userRepository.save(user);
        return R.builder().success().message("\u4fee\u6539\u6210\u529f").build();
    }
}

