/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.service.login.impl;

import cn.xisoil.dao.permission.PermissionRepository;
import cn.xisoil.dao.role.RoleRepository;
import cn.xisoil.data.pojo.permission.Permission;
import cn.xisoil.data.pojo.role.Role;
import cn.xisoil.exception.ResponseException;
import cn.xisoil.service.login.LoginPermissionUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class LoginPermissionUtilsImpl
implements LoginPermissionUtils {
    @Autowired
    private PermissionRepository permissionRepository;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    @PersistenceContext
    EntityManager entityManager;

    @Override
    public List<Permission> structureByRoleId(String roleId) {
        Role role = (Role)this.roleRepository.findById(roleId).orElseThrow(() -> new ResponseException(403, "\u8d26\u6237\u5df2\u88ab\u53d6\u6d88\u6388\u6743\uff01"));
        Session session = (Session)this.entityManager.unwrap(Session.class);
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(criteriaBuilder.or((Expression)criteriaBuilder.and((Expression)root.get("id").in(role.getPermissionIds()), (Expression)root.get("parentId").isNull()), (Expression)criteriaBuilder.and(new Predicate[]{root.get("id").in(role.getPermissionIds()), criteriaBuilder.not((Expression)root.get("parentId").in(role.getPermissionIds())), root.get("parentId").isNotNull()})));
            criteriaQuery.orderBy(new Order[]{criteriaBuilder.asc((Expression)root.get("comparable"))});
            return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        };
        List permissions = this.permissionRepository.findAll(specification);
        return permissions;
    }
}

