/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.service.datacheck;

import cn.xisoil.annotation.permission.PermissionCheckAutomation;
import cn.xisoil.dao.permission.PermissionRepository;
import cn.xisoil.dao.role.RoleRepository;
import cn.xisoil.data.pojo.permission.Permission;
import cn.xisoil.data.pojo.role.Role;
import cn.xisoil.utils.SpringContextUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PermissionCheckAutomationSystem {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PermissionRepository permissionRepository;
    @Autowired
    private SpringContextUtils springContextUtils;
    private List<PermissionCheckAutomation> permissionCheckAutomations = new ArrayList<PermissionCheckAutomation>();
    @Autowired
    private RoleRepository roleRepository;

    @Autowired
    public void setPermissionCheckAutomationMap() {
        this.permissionCheckAutomations = this.springContextUtils.getBeansForType(PermissionCheckAutomation.class);
    }

    void checkPermission() {
        this.logger.info("\u6570\u636e\u68c0\u67e5==>\u6743\u9650\u68c0\u67e5\u5f00\u59cb");
        this.permissionCheckAutomations.forEach(v -> {
            if (v.auto()) {
                this.logger.info("\u6743\u9650\u68c0\u67e5==>{}", (Object)v.getName());
                Permission permission = this.permissionRepository.findTopByName(v.getName()).orElse(new Permission(v.getName(), v.getUrl()));
                if (StringUtils.isNotBlank((CharSequence)v.getParent())) {
                    Permission parent = this.permissionRepository.findTopByName(v.getParent()).orElse(new Permission(v.getParent(), v.getUrl() + "Admin", "apps-o"));
                    parent = (Permission)this.permissionRepository.save(parent);
                    permission.setParentId(parent.getId());
                } else {
                    permission.setIco("apps-o");
                }
                this.permissionRepository.save(permission);
                this.logger.info("\u6743\u9650\u68c0\u67e5==>{} \u6210\u529f", (Object)v.getName());
            }
        });
    }

    String checkRole() {
        List<String> permissionIds = this.permissionRepository.findAllId();
        Role role = this.roleRepository.findTopByIdNotNull().orElse(new Role("\u521d\u59cb\u5316\u89d2\u8272"));
        role.setPermissionIds(permissionIds);
        role = (Role)this.roleRepository.save(role);
        this.logger.info("\u89d2\u8272\u68c0\u67e5==>\u6210\u529f");
        return role.getId();
    }
}

