/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.service.datacheck;

import cn.xisoil.dao.user.UserRepository;
import cn.xisoil.data.pojo.user.LoginUser;
import cn.xisoil.data.properties.AutoMationProperties;
import cn.xisoil.service.datacheck.PermissionCheckAutomationSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Component;

@Component
public class DataCheckAutomation
implements ApplicationRunner {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private AutoMationProperties autoMationProperties;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private PermissionCheckAutomationSystem permissionCheckAutomationSystem;

    public void run(ApplicationArguments args) throws Exception {
        if (this.autoMationProperties.getCheck().booleanValue()) {
            this.logger.info("\u6570\u636e\u68c0\u67e5==>\u6570\u636e\u68c0\u67e5\u5f00\u59cb");
            this.permissionCheckAutomationSystem.checkPermission();
            String roleId = this.permissionCheckAutomationSystem.checkRole();
            LoginUser yueLoginUser = this.userRepository.findOneByAccount(this.autoMationProperties.getUser().getUsername()).orElse(new LoginUser(this.autoMationProperties.getUser().getUsername()));
            BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
            String encode = passwordEncoder.encode((CharSequence)this.autoMationProperties.getUser().getPassword());
            yueLoginUser.setPassword(encode);
            yueLoginUser.setRoleId(roleId);
            this.userRepository.save(yueLoginUser);
            this.logger.info("\u521d\u59cb\u5316\u7528\u6237==>{}", (Object)yueLoginUser.getAccount());
        }
    }
}

