/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.model.service.model.impl;

import cn.xisoil.annotation.model.CurdModel;
import cn.xisoil.annotation.model.CurdModelObject;
import cn.xisoil.data.enums.ObjectColumnType;
import cn.xisoil.model.data.ModelClass;
import cn.xisoil.model.data.ModelColumn;
import cn.xisoil.model.service.model.ModelService;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Service;

@Service
public class ModelServiceImpl
implements ModelService {
    private static final List<ObjectColumnType> KEYWORD_SEARCH = Arrays.asList(ObjectColumnType.STRING, ObjectColumnType.NUMBER, ObjectColumnType.TEXTAREA);
    private static final List<ObjectColumnType> LIST_SEARCH = Arrays.asList(ObjectColumnType.LIST, ObjectColumnType.CHECKBOX, ObjectColumnType.RADIO, ObjectColumnType.LISTMULTISELECT);

    @Override
    public List<ModelColumn> getModelColumns(Class<?> clazz) {
        LinkedList<Field[]> list = new LinkedList<Field[]>();
        ArrayList<ModelColumn> modelColumns = new ArrayList<ModelColumn>();
        list.add(clazz.getSuperclass().getDeclaredFields());
        list.add(clazz.getDeclaredFields());
        list.forEach(fields -> {
            for (Field field : fields) {
                boolean annotationPresent = field.isAnnotationPresent(CurdModel.class);
                if (!annotationPresent) continue;
                CurdModel curdModel = field.getAnnotation(CurdModel.class);
                modelColumns.add(ModelColumn.builder().column(field.getName()).name(curdModel.value()).type(curdModel.type()).edit(curdModel.editor()).search(curdModel.search()).show(curdModel.show()).url(curdModel.url()).comparable(curdModel.comparable()).required(curdModel.required()).placeholder(curdModel.placeholder()).group(curdModel.group()).build());
            }
        });
        return modelColumns;
    }

    @Override
    public ModelClass getModelClass(Class<?> clazz) {
        CurdModelObject modelClass = clazz.getAnnotation(CurdModelObject.class);
        ModelClass yueModelClassData = new ModelClass();
        if (modelClass != null) {
            yueModelClassData.setAdd(modelClass.add());
            yueModelClassData.setName(modelClass.value());
            yueModelClassData.setEdit(modelClass.edit());
            yueModelClassData.setDelete(modelClass.delete());
        }
        return yueModelClassData;
    }

    @Override
    public List<String> getSearchColumn(Class<?> clazz) {
        LinkedList<Field[]> list = new LinkedList<Field[]>();
        ArrayList<String> columns = new ArrayList<String>();
        list.add(clazz.getSuperclass().getDeclaredFields());
        list.add(clazz.getDeclaredFields());
        list.forEach(fields -> {
            for (Field field : fields) {
                boolean annotationPresent = field.isAnnotationPresent(CurdModel.class);
                CurdModel curdModel = field.getAnnotation(CurdModel.class);
                if (!annotationPresent || !curdModel.search() || !KEYWORD_SEARCH.contains((Object)curdModel.type())) continue;
                columns.add(field.getName());
            }
        });
        return columns;
    }

    @Override
    public List<Field> getFieldsByAnnotation(Class<?> clazz, Class<? extends Annotation> annotation) {
        LinkedList<Field[]> list = new LinkedList<Field[]>();
        ArrayList<Field> columns = new ArrayList<Field>();
        list.add(clazz.getSuperclass().getDeclaredFields());
        list.add(clazz.getDeclaredFields());
        list.forEach(fields -> {
            for (Field field : fields) {
                boolean annotationPresent = field.isAnnotationPresent(annotation);
                if (!annotationPresent) continue;
                columns.add(field);
            }
        });
        return columns;
    }

    @Override
    public List<ModelColumn> getListSearchColumn(Class<?> clazz) {
        LinkedList<Field[]> list = new LinkedList<Field[]>();
        ArrayList<ModelColumn> modelColumns = new ArrayList<ModelColumn>();
        list.add(clazz.getSuperclass().getDeclaredFields());
        list.add(clazz.getDeclaredFields());
        list.forEach(fields -> {
            for (Field field : fields) {
                boolean annotationPresent = field.isAnnotationPresent(CurdModel.class);
                CurdModel curdModel = field.getAnnotation(CurdModel.class);
                if (!annotationPresent || !curdModel.search() || !LIST_SEARCH.contains((Object)curdModel.type())) continue;
                modelColumns.add(ModelColumn.builder().column(field.getName()).type(curdModel.type()).build());
            }
        });
        return modelColumns;
    }

    @Override
    public String getName(Class<?> clazz) {
        CurdModelObject modelClass = (CurdModelObject)AnnotationUtils.getAnnotation(clazz, CurdModelObject.class);
        if (modelClass != null) {
            return modelClass.value();
        }
        return "";
    }
}

