/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.model.service.list;

import cn.xisoil.annotation.curd.SelectBy;
import cn.xisoil.annotation.curd.enums.SCOPE;
import cn.xisoil.dao.utils.YueRepository;
import cn.xisoil.data.result.R;
import cn.xisoil.data.to.ListStringRequest;
import cn.xisoil.data.to.SearchPageRequest;
import cn.xisoil.data.to.SearchSoRequest;
import cn.xisoil.exception.NormalException;
import cn.xisoil.model.data.ModelColumn;
import cn.xisoil.model.service.model.ModelService;
import cn.xisoil.utils.GenericObject;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.transaction.Transactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;

public class CurdDaoServiceImpl<T, V extends YueRepository<T, String>>
extends GenericObject<T> {
    @Autowired
    private V repository;
    @Autowired
    private ModelService modelService;

    @Transactional
    public R<String> delete(ListStringRequest request) {
        this.repository.deleteAllByIdIn(request.getIds());
        return R.builder().message("\u5220\u9664\u6210\u529f").success().build();
    }

    public R<String> edit(T request) {
        Object t = this.repository.findById((Object)JSONObject.parseObject((String)JSON.toJSONString(request)).getString("id")).orElseThrow(() -> new NormalException("\u6570\u636e\u4e0d\u5b58\u5728"));
        BeanUtils.copyProperties(request, t);
        this.repository.save(t);
        return R.builder().success().message("\u4fee\u6539\u6210\u529f").build();
    }

    public R<String> add(T request) {
        Object t = this.object();
        BeanUtils.copyProperties(request, t);
        this.repository.save(t);
        return R.builder().success().message("\u6dfb\u52a0\u6210\u529f").build();
    }

    public R<Page<T>> page(SearchPageRequest searchPageRequest) {
        PageRequest pageable = PageRequest.of((int)searchPageRequest.getPageNum(), (int)searchPageRequest.getPageSize(), (Sort.Direction)searchPageRequest.getSortType(), (String[])new String[]{searchPageRequest.getColumn()});
        Specification & Serializable sectionSpecification = (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            List<String> searchColumns = this.modelService.getSearchColumn(this.getGenericClass());
            if (StringUtils.isNotBlank((CharSequence)searchPageRequest.getKeyword())) {
                ArrayList searchPredicates = new ArrayList();
                searchColumns.forEach(s -> searchPredicates.add(criteriaBuilder.or(new Predicate[]{criteriaBuilder.like((Expression)root.get(s), "%" + searchPageRequest.getKeyword() + "%")})));
                predicates.add(criteriaBuilder.or(searchPredicates.toArray(new Predicate[0])));
            }
            List<ModelColumn> searchListColumns = this.modelService.getListSearchColumn(this.getGenericClass());
            searchListColumns.forEach(searchListColumn -> {
                if (StringUtils.isNotBlank((CharSequence)searchPageRequest.getString(searchListColumn.getColumn()))) {
                    predicates.add(criteriaBuilder.equal(root.get(searchListColumn.getColumn()).as(String.class), searchPageRequest.get(searchListColumn.getColumn())));
                }
            });
            this.modelService.getFieldsByAnnotation(this.getGenericClass(), SelectBy.class).stream().filter(field -> Arrays.stream(field.getAnnotation(SelectBy.class).scope()).toList().contains((Object)SCOPE.LIST)).forEach(s -> {
                switch (s.getAnnotation(SelectBy.class).select()) {
                    case ISEMPTY: {
                        predicates.add(criteriaBuilder.or((Expression)root.get(s.getName()).isNull(), (Expression)criteriaBuilder.equal((Expression)root.get(s.getName()), (Object)"")));
                        break;
                    }
                    case ISNULL: {
                        predicates.add(root.get(s.getName()).isNull());
                        break;
                    }
                    case NOTNULL: {
                        predicates.add(root.get(s.getName()).isNotNull());
                        break;
                    }
                    case NOTEMPTY: {
                        predicates.add(criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get(s.getName()), (Object)""), (Expression)root.get(s.getName()).isNotNull()));
                    }
                }
            });
            return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        };
        Page page = this.repository.findAll((Specification)sectionSpecification, (Pageable)pageable);
        return R.builder().message("\u83b7\u53d6\u6210\u529f").success().data(page).build();
    }

    public R<List<T>> list() {
        List list = this.repository.findAll();
        return R.builder().success().message("\u83b7\u53d6\u6210\u529f").data(list).build();
    }

    public R<List<T>> search(SearchSoRequest searchSoRequest) {
        Specification & Serializable sectionSpecification = (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            List<String> searchColumns = this.modelService.getSearchColumn(this.getGenericClass());
            if (StringUtils.isNotBlank((CharSequence)searchSoRequest.getKeyword()) && !searchColumns.isEmpty()) {
                ArrayList searchPredicates = new ArrayList();
                searchColumns.forEach(s -> searchPredicates.add(criteriaBuilder.or(new Predicate[]{criteriaBuilder.like((Expression)root.get(s), "%" + searchSoRequest.getKeyword() + "%")})));
                predicates.add(criteriaBuilder.or(searchPredicates.toArray(new Predicate[0])));
            }
            if (searchSoRequest.getIds().size() > 0) {
                predicates.add(root.get("id").in(searchSoRequest.getIds()));
            }
            return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        };
        List list = this.repository.findAll((Specification)sectionSpecification);
        return R.builder().message("\u83b7\u53d6\u6210\u529f").success().data(list).build();
    }

    public R<T> get(String id) {
        Object t = this.repository.findById((Object)id).orElseThrow(() -> new NormalException("\u6570\u636e\u4e0d\u5b58\u5728"));
        return R.builder().success().data(t).message("\u83b7\u53d6\u6210\u529f").build();
    }
}

