/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.model.controller;

import cn.xisoil.annotation.permission.PermissionCheckAutomation;
import cn.xisoil.dao.utils.YueRepository;
import cn.xisoil.data.enums.ObjectType;
import cn.xisoil.data.result.R;
import cn.xisoil.model.data.ModelClass;
import cn.xisoil.model.data.ModelColumn;
import cn.xisoil.model.service.model.ModelService;
import cn.xisoil.model.service.single.SingleDaoServiceImpl;
import jakarta.validation.Valid;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

public abstract class SingleModelController<T, V extends YueRepository<T, String>>
extends SingleDaoServiceImpl<T, V>
implements PermissionCheckAutomation<T> {
    @Autowired
    private ModelService modelService;

    @GetMapping(value={"/columns"})
    public R<ModelClass> columns() {
        ModelClass yueModelClass = this.modelService.getModelClass(super.getGenericClass());
        yueModelClass.setType(ObjectType.SINGLE);
        List<ModelColumn> columns = this.modelService.getModelColumns(super.getGenericClass());
        Map<String, List<ModelColumn>> groups = columns.stream().collect(Collectors.groupingBy(ModelColumn::getGroup));
        yueModelClass.setColumns(columns);
        yueModelClass.setGroups(groups);
        return R.builder().data(yueModelClass).success().message("\u83b7\u53d6\u6210\u529f").build();
    }

    @Override
    @GetMapping(value={""})
    public R<T> get() {
        return super.get();
    }

    @PutMapping(value={""})
    public R<String> edit(@Valid @RequestBody T r, BindingResult result) {
        Iterator iterator;
        if (result.hasErrors() && (iterator = result.getAllErrors().iterator()).hasNext()) {
            ObjectError error = (ObjectError)iterator.next();
            return R.builder().fail().code(500).message(error.getDefaultMessage()).build();
        }
        return super.edit(r);
    }
}

