/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.model.controller;

import cn.xisoil.annotation.permission.PermissionCheckAutomation;
import cn.xisoil.dao.utils.YueRepository;
import cn.xisoil.data.enums.ObjectType;
import cn.xisoil.data.result.R;
import cn.xisoil.data.to.ListStringRequest;
import cn.xisoil.data.to.SearchPageRequest;
import cn.xisoil.data.to.SearchSoRequest;
import cn.xisoil.model.data.ModelClass;
import cn.xisoil.model.data.ModelColumn;
import cn.xisoil.model.service.list.CurdDaoServiceImpl;
import cn.xisoil.model.service.model.ModelService;
import jakarta.validation.Valid;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

public abstract class ModelCurdControllerMapping<T, V extends YueRepository<T, String>>
extends CurdDaoServiceImpl<T, V>
implements PermissionCheckAutomation<T> {
    @Autowired
    private ModelService modelService;

    @GetMapping(value={"/columns"})
    public R<ModelClass> columns() {
        ModelClass yueModelClass = this.modelService.getModelClass(super.getGenericClass());
        List<ModelColumn> columns = this.modelService.getModelColumns(super.getGenericClass());
        Map<String, List<ModelColumn>> groups = columns.stream().collect(Collectors.groupingBy(ModelColumn::getGroup));
        yueModelClass.setColumns(columns);
        yueModelClass.setGroups(groups);
        yueModelClass.setType(ObjectType.LIST);
        return R.builder().data(yueModelClass).success().message("\u83b7\u53d6\u6210\u529f").build();
    }

    @PostMapping(value={"/page"})
    public R<Page<T>> page(@Valid @RequestBody SearchPageRequest searchPageRequest, BindingResult result) {
        Iterator iterator;
        if (result.hasErrors() && (iterator = result.getAllErrors().iterator()).hasNext()) {
            ObjectError error = (ObjectError)iterator.next();
            return R.builder().fail().code(500).message(error.getDefaultMessage()).build();
        }
        return super.page(searchPageRequest);
    }

    @Override
    @GetMapping(value={"/list"})
    public R<List<T>> list() {
        return super.list();
    }

    @Override
    @PostMapping(value={"/search"})
    public R<List<T>> search(@RequestBody SearchSoRequest searchSoRequest) {
        return super.search(searchSoRequest);
    }

    @PostMapping(value={"/delete"})
    protected R<String> delete(@Valid @RequestBody ListStringRequest stringRequest, BindingResult result) {
        Iterator iterator;
        if (result.hasErrors() && (iterator = result.getAllErrors().iterator()).hasNext()) {
            ObjectError error = (ObjectError)iterator.next();
            return R.builder().fail().code(500).message(error.getDefaultMessage()).build();
        }
        return super.delete(stringRequest);
    }

    @PutMapping(value={""})
    public R<String> edit(@Valid @RequestBody T request, BindingResult result) {
        Iterator iterator;
        if (result.hasErrors() && (iterator = result.getAllErrors().iterator()).hasNext()) {
            ObjectError error = (ObjectError)iterator.next();
            return R.builder().fail().code(500).message(error.getDefaultMessage()).build();
        }
        return super.edit(request);
    }

    @PostMapping(value={""})
    protected R<String> add(@Valid @RequestBody T request, BindingResult result) {
        Iterator iterator;
        if (result.hasErrors() && (iterator = result.getAllErrors().iterator()).hasNext()) {
            ObjectError error = (ObjectError)iterator.next();
            return R.builder().fail().code(500).message(error.getDefaultMessage()).build();
        }
        return super.add(request);
    }

    @Override
    @GetMapping(value={"/{id}"})
    public R<T> get(@PathVariable String id) {
        return super.get(id);
    }
}

