/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.exception.advice;

import cn.xisoil.data.enums.HTTPCODE;
import cn.xisoil.data.result.R;
import cn.xisoil.exception.AuthException;
import cn.xisoil.exception.NormalException;
import cn.xisoil.exception.ResponseException;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class YueRestExceptionController {
    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public R<?> jsonParseError(HttpServletRequest request, Throwable ex) {
        return R.builder().code(this.getStatus(request).value()).message(ex.getMessage()).build();
    }

    @ExceptionHandler(value={NormalException.class})
    public R<?> NormalError(HttpServletRequest request, Throwable ex) {
        return R.builder().code(this.getStatus(request).value()).message(ex.getMessage()).build();
    }

    @ExceptionHandler(value={AuthException.class})
    public R<?> AuthError(HttpServletRequest request, Throwable ex) {
        return R.builder().code(HTTPCODE.FORBIDDEN.getCode()).message(ex.getMessage()).build();
    }

    @ExceptionHandler(value={ResponseException.class})
    public R<?> ResponseError(HttpServletRequest request, Throwable ex) {
        return R.builder().code(this.getStatus(request).value()).message(ex.getMessage()).build();
    }

    private HttpStatus getStatus(HttpServletRequest request) {
        Integer statusCode = (Integer)request.getAttribute("jakarta.servlet.error.status_code");
        if (statusCode == null) {
            return HttpStatus.INTERNAL_SERVER_ERROR;
        }
        return HttpStatus.valueOf((int)statusCode);
    }
}

