/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.data.result;

import cn.xisoil.data.enums.HTTPCODE;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class R<T> {
    private final String result;
    private final Integer code;
    private final String message;
    private final T data;

    public static <T> R<T> ok() {
        return new Builder().build();
    }

    public static <T> R<T> ok(T t, String message) {
        return new Builder<T>().data(t).message(message).build();
    }

    public static <T> R<T> ok(T t) {
        return new Builder<T>().data(t).build();
    }

    public static <T> R<T> fail() {
        return new Builder().code(500).build();
    }

    public static <T> R<T> fail(String message) {
        return new Builder().code(500).message(message).build();
    }

    private R(Builder<T> builder) {
        this.result = builder.result;
        this.code = builder.code;
        this.message = builder.message;
        this.data = builder.data;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public String getResult() {
        return this.result;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public static class Builder<T> {
        private String result;
        private Integer code = 200;
        private String message;
        private T data;

        public Builder<T> code(Integer code) {
            this.code = code;
            return this;
        }

        public Builder<T> message(String message) {
            this.message = message;
            return this;
        }

        public Builder<T> result(String result) {
            this.result = result;
            return this;
        }

        public Builder<T> result(HTTPCODE result) {
            this.result = result.getMessage();
            this.code = result.getCode();
            return this;
        }

        public Builder<T> success() {
            this.result = "SUCCESS";
            this.code = 200;
            return this;
        }

        public Builder<T> fail() {
            this.result = "FAILURE";
            this.code = 500;
            return this;
        }

        public Builder<T> data(T data) {
            this.data = data;
            return this;
        }

        public R<T> build() {
            return new R(this);
        }
    }
}

