/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.data.pojo.permission;

import cn.xisoil.annotation.curd.SelectBy;
import cn.xisoil.annotation.curd.enums.SELECT;
import cn.xisoil.annotation.model.CurdModel;
import cn.xisoil.annotation.model.CurdModelObject;
import cn.xisoil.data.enums.ObjectColumnType;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.ParamDef;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity(name="Permission")
@Table(name="permission")
@EntityListeners(value={AuditingEntityListener.class})
@CurdModelObject(value="\u6743\u9650\u7ba1\u7406")
@FilterDef(name="permissionChildren", parameters={@ParamDef(name="ids", type=String.class)})
public class Permission {
    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy="uuid")
    @Column(columnDefinition="varchar(32)")
    private String id;
    @CurdModel(value="\u6240\u5c5e\u7236\u7ea7", show=false, search=true, url="/permission/list", type=ObjectColumnType.LIST)
    @Column(columnDefinition="varchar(32)")
    @SelectBy(select=SELECT.ISNULL)
    private String parentId;
    @OneToMany(fetch=FetchType.EAGER)
    @JoinColumn(name="parentId", columnDefinition="varchar(32)")
    @JsonIgnoreProperties(value={"children"})
    @Fetch(value=FetchMode.SUBSELECT)
    @Filter(name="permissionChildren", condition=" id in (:ids)   ")
    @OrderBy(value="comparable asc ")
    private Set<Permission> children = new HashSet<Permission>();
    @CurdModel(value="\u6743\u9650\u540d\u79f0")
    private String name;
    private Date createTime;
    @Column(name="`key`")
    private String key;
    @CurdModel(value="\u6392\u5e8f", comparable=true, type=ObjectColumnType.NUMBER)
    private Integer comparable;
    private String title;
    @CurdModel(value="\u6743\u9650\u5730\u5740")
    @Column(unique=true)
    private String path;
    @CurdModel(value="\u6743\u9650\u56fe\u6807", url="/ico/list", type=ObjectColumnType.LIST)
    private String ico;

    public Permission() {
    }

    public Permission(String title, String path, String ico) {
        this.title = title;
        this.name = title;
        this.path = path;
        this.ico = ico;
    }

    public Permission(String title, String path) {
        this.title = title;
        this.name = title;
        this.path = path;
    }

    public String getTitle() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public void setChildren(Set<Permission> children) {
        this.children = children;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setComparable(Integer comparable) {
        this.comparable = comparable;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setIco(String ico) {
        this.ico = ico;
    }

    public Set<Permission> getChildren() {
        return this.children;
    }

    public String getName() {
        return this.name;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getKey() {
        return this.key;
    }

    public Integer getComparable() {
        return this.comparable;
    }

    public String getPath() {
        return this.path;
    }

    public String getIco() {
        return this.ico;
    }
}

