/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.dao.utils.impl;

import cn.xisoil.annotation.batch.BatchSQLDelete;
import cn.xisoil.dao.utils.BatchRepository;
import com.fasterxml.jackson.annotation.JsonFormat;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.SQLDelete;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;

public class BatchRepositoryImpl<T, ID extends Serializable>
extends SimpleJpaRepository<T, ID>
implements BatchRepository<T, ID> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private EntityManager entityManager;
    private Field[] fields = null;
    private String tableName;
    private String entityName;
    private String id = "id";
    private Field idField;
    private Class<T> tClass;
    private Integer BATCH_SIZE = 1000;

    public BatchRepositoryImpl(JpaEntityInformation<T, ?> entityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
        this.entityManager = entityManager;
        this.tClass = this.getDomainClass();
        this.fields = this.tClass.getDeclaredFields();
        this.tableName = this.getTableName();
        this.entityName = this.getEntityName();
        this.id = this.getId();
    }

    public BatchRepositoryImpl(Class<T> domainClass, EntityManager em) {
        super(domainClass, em);
        this.entityManager = em;
    }

    @Override
    public void saveAll(List<T> list) {
        StringBuilder sb = this.into();
        int i = 0;
        for (T dis : list) {
            if (++i > 1) {
                sb.append(",");
            }
            sb.append("(");
            for (Field field : this.fields) {
                field.setAccessible(true);
                if (this.isIgnore(field)) continue;
                try {
                    if (!sb.toString().endsWith("(")) {
                        sb.append(",");
                    }
                    if (field.get(dis) instanceof List || field.get(dis) instanceof Set) {
                        String list1 = field.get(dis).toString();
                        sb.append("'").append(list1.replace("[", "").replace("]", "")).append("'");
                        continue;
                    }
                    if (field.get(dis) instanceof Boolean) {
                        sb.append((Boolean)field.get(dis) != false ? 1 : 0);
                        continue;
                    }
                    if (field.get(dis) instanceof Date) {
                        if (field.getAnnotation(JsonFormat.class) != null) {
                            sb.append("'").append(new SimpleDateFormat(field.getAnnotation(JsonFormat.class).pattern()).format(field.get(dis))).append("'");
                            continue;
                        }
                        sb.append("'").append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(field.get(dis))).append("'");
                        continue;
                    }
                    if (field.get(dis) instanceof Enum) {
                        if (field.getAnnotation(Enumerated.class) != null && field.getAnnotation(Enumerated.class).value().equals((Object)EnumType.STRING)) {
                            sb.append("'").append(((Enum)field.get(dis)).name()).append("'");
                            continue;
                        }
                        sb.append(((Enum)field.get(dis)).ordinal());
                        continue;
                    }
                    if (field.get(dis) == null) {
                        sb.append("NULL");
                        continue;
                    }
                    if (field.get(dis).toString().contains("'")) {
                        sb.append("'").append(field.get(dis).toString().replace("'", "''")).append("'");
                        continue;
                    }
                    sb.append("'").append(field.get(dis)).append("'");
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            sb.append(")");
            if (i < this.BATCH_SIZE) continue;
            this.setUpdate(sb);
            this.entityManager.createNativeQuery(sb.toString()).executeUpdate();
            i = 0;
            sb = this.into();
        }
        if (i > 0) {
            this.setUpdate(sb);
            this.entityManager.createNativeQuery(sb.toString()).executeUpdate();
        }
    }

    @Override
    public void deleteAll() {
        this.entityManager.createQuery("delete from " + this.entityName + " en ").executeUpdate();
    }

    @Override
    public List<T> findAllByIds(List<ID> ids) {
        List tList = this.entityManager.createQuery("select en from " + this.entityName + " en where en." + this.id + " in :ids").setParameter("ids", ids).getResultList();
        return tList;
    }

    @Override
    public boolean deleteAllByIds(List list) {
        String sql;
        SQLDelete sqlDelete = this.getDomainClass().getAnnotation(SQLDelete.class);
        if (sqlDelete != null && (sql = sqlDelete.sql()) != null && !sql.isEmpty()) {
            System.out.println(sql);
        }
        return false;
    }

    @Override
    public boolean deleteAll(List<T> list) {
        ArrayList<Serializable> ids = new ArrayList<Serializable>();
        for (T t : list) {
            try {
                ids.add((Serializable)this.idField.get(t));
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
                return false;
            }
        }
        this.deleteAllByIdIn(ids);
        return true;
    }

    @Override
    public void deleteAllByIdIn(List<ID> ids) {
        BatchSQLDelete sqlDelete = this.tClass.getAnnotation(BatchSQLDelete.class);
        if (sqlDelete == null) {
            this.entityManager.createQuery("delete from " + this.entityName + " en  where en." + this.id + " in (:ids)").setParameter("ids", ids).executeUpdate();
        } else if (sqlDelete.nativeQuery()) {
            this.entityManager.createNativeQuery(sqlDelete.value()).setParameter(1, ids).executeUpdate();
        } else {
            this.entityManager.createQuery(sqlDelete.value()).setParameter(1, ids).executeUpdate();
        }
    }

    @Override
    public Optional<T> findTopByIdNotNull() {
        Optional<Object> tOptional = Optional.of(this.entityManager.createQuery("select en from " + this.entityName + " en where " + this.idField.getName() + " is not null ").setMaxResults(1).getSingleResult());
        return tOptional;
    }

    private String getId() {
        for (Field field : this.fields) {
            if (field.getAnnotation(Id.class) == null) continue;
            this.id = field.getName();
            this.idField = field;
            break;
        }
        return this.id;
    }

    private String getTableName() {
        String tableName = this.tClass.getSimpleName();
        tableName = BatchRepositoryImpl.toUnderlineName(tableName);
        if (this.tClass.getAnnotation(Table.class) != null) {
            Table table = this.tClass.getAnnotation(Table.class);
            tableName = table.name();
        }
        return tableName;
    }

    private String getEntityName() {
        String entityName = this.tClass.getSimpleName();
        if (this.tClass.getAnnotation(Entity.class) != null) {
            Entity table = this.tClass.getAnnotation(Entity.class);
            entityName = table.name();
        }
        return entityName;
    }

    private static String toUnderlineName(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean upperCase = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            boolean nextUpperCase = true;
            if (i < s.length() - 1) {
                nextUpperCase = Character.isUpperCase(s.charAt(i + 1));
            }
            if (i >= 0 && Character.isUpperCase(c)) {
                if (!(upperCase && nextUpperCase || i <= 0)) {
                    sb.append("_");
                }
                upperCase = true;
            } else {
                upperCase = false;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    private boolean isIgnore(Field field) {
        return field.getAnnotation(Transient.class) != null || field.getAnnotation(OneToMany.class) != null || field.getAnnotation(ManyToMany.class) != null || field.getAnnotation(OneToOne.class) != null || field.getAnnotation(ManyToOne.class) != null;
    }

    private StringBuilder into() {
        StringBuilder sb = new StringBuilder();
        sb.append("insert into " + this.tableName + "(");
        for (int i = 0; i < this.fields.length; ++i) {
            Column column;
            if (this.isIgnore(this.fields[i])) continue;
            if (i > 0) {
                sb.append(",");
            }
            if (this.tClass.getAnnotation(Column.class) != null && StringUtils.isNotBlank((CharSequence)(column = this.fields[i].getAnnotation(Column.class)).name())) {
                sb.append(column.name());
                continue;
            }
            sb.append(BatchRepositoryImpl.toUnderlineName(this.fields[i].getName()));
        }
        sb.append(") values");
        return sb;
    }

    private StringBuilder setUpdate(StringBuilder sb) {
        sb.append(" ON DUPLICATE KEY UPDATE ");
        for (Field field : this.fields) {
            field.setAccessible(true);
            if (this.isIgnore(field)) continue;
            try {
                Column column;
                if (field.getAnnotation(Id.class) != null) continue;
                if (!sb.toString().endsWith("UPDATE ")) {
                    sb.append(",");
                }
                if (field.getAnnotation(Column.class) != null && StringUtils.isNotBlank((CharSequence)(column = field.getAnnotation(Column.class)).name())) {
                    sb.append(column.name()).append("=VALUES(").append(column.name()).append(")");
                    continue;
                }
                sb.append(BatchRepositoryImpl.toUnderlineName(field.getName())).append("=VALUES(").append(BatchRepositoryImpl.toUnderlineName(field.getName())).append(")");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return sb;
    }
}

