/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.controller.login;

import cn.xisoil.annotation.log.LoginLog;
import cn.xisoil.dao.user.UserRepository;
import cn.xisoil.data.dto.login.EditUserRequest;
import cn.xisoil.data.dto.login.LoginDto;
import cn.xisoil.data.dto.login.LoginRequest;
import cn.xisoil.data.pojo.user.LoginUser;
import cn.xisoil.data.result.R;
import cn.xisoil.exception.ResponseException;
import cn.xisoil.model.controller.SingleModelController;
import cn.xisoil.service.login.LoginService;
import jakarta.validation.Valid;
import java.util.Iterator;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/manage/auth"})
public class LoginController
extends SingleModelController<LoginUser, UserRepository> {
    @Autowired
    private LoginService loginService;

    @PostMapping(value={"/login"})
    @LoginLog
    public R<LoginDto> userLogin(@Valid @RequestBody LoginRequest request, BindingResult result) {
        Iterator iterator;
        if (result.hasErrors() && (iterator = result.getAllErrors().iterator()).hasNext()) {
            ObjectError error = (ObjectError)iterator.next();
            throw new ResponseException(500, error.getDefaultMessage());
        }
        return this.loginService.userLogin(request);
    }

    @Override
    @GetMapping(value={"", "/userInfo"})
    @Primary
    public R<LoginUser> get() {
        return this.loginService.getUserInfo();
    }

    @Override
    @PutMapping(value={""})
    @Primary
    public R<String> edit(@Valid @RequestBody LoginUser request, BindingResult result) {
        EditUserRequest user = new EditUserRequest();
        BeanUtils.copyProperties((Object)request, (Object)user);
        return this.loginService.edit(user);
    }
}

