/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.config.token;

import cn.xisoil.exception.ResponseException;
import com.alibaba.fastjson.JSON;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class JwtInterceptor
implements HandlerInterceptor {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String method = request.getMethod();
        if ("OPTIONS".equals(method)) {
            return true;
        }
        String token = request.getHeader("token");
        if (token != null) {
            try {
                JwtParser jwtParser = Jwts.parser();
                jwtParser.setSigningKey("java666");
                Jws claimsJws = jwtParser.parseClaimsJws(token);
                return true;
            }
            catch (ExpiredJwtException e) {
                throw new ResponseException(401, "Token\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u9646\uff01");
            }
            catch (Exception e) {
                throw new ResponseException(401, "Token\u4e0d\u5408\u6cd5\uff0c\u8bf7\u81ea\u91cd\uff01");
            }
        }
        throw new ResponseException(401, "Token\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u9646\uff01");
    }

    public void doResponse(HttpServletResponse response, String info) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        PrintWriter writer = response.getWriter();
        ResponseEntity responseEntity = new ResponseEntity((Object)info, (HttpStatusCode)HttpStatus.UNAUTHORIZED);
        String json = JSON.toJSONString((Object)responseEntity);
        writer.write(json);
        writer.flush();
        writer.close();
    }
}

