/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.asp.log;

import cn.xisoil.annotation.log.Log;
import cn.xisoil.config.token.JwtUtils;
import cn.xisoil.dao.basic.BasicDataRepository;
import cn.xisoil.data.dto.login.LoginDto;
import cn.xisoil.data.dto.login.LoginRequest;
import cn.xisoil.data.pojo.log.LoginLog;
import cn.xisoil.data.pojo.log.SystemLog;
import cn.xisoil.data.pojo.user.LoginUser;
import cn.xisoil.data.result.R;
import cn.xisoil.exception.ResponseException;
import cn.xisoil.service.log.LoginLogService;
import cn.xisoil.service.log.YueSystemLogDataService;
import cn.xisoil.utils.HttpRequestIpUtils;
import jakarta.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@Aspect
public class LogUtils {
    @Autowired
    private HttpRequestIpUtils httpRequestIpUtils;
    @Autowired
    private LoginLogService loginLogService;
    @Autowired
    private JwtUtils jwtUtils;
    @Autowired
    private YueSystemLogDataService yueSystemLogDataService;
    @Autowired
    private BasicDataRepository basicDataRepository;

    @Pointcut(value="@annotation(cn.xisoil.annotation.log.LoginLog)")
    public void YueLoginLogCut() {
    }

    @Pointcut(value="@annotation(cn.xisoil.annotation.log.Log)")
    public void YueSystemLogCut() {
    }

    @AfterReturning(value="YueLoginLogCut()", returning="result")
    public void loginLog(R<LoginDto> result) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        LoginLog yueLoginLogData = new LoginLog();
        yueLoginLogData.setIp(this.httpRequestIpUtils.getIpAddress(request));
        LoginUser yueLoginUser = result.getData().getUser();
        yueLoginLogData.setAccount(yueLoginUser.getAccount());
        yueLoginLogData.setIp(this.httpRequestIpUtils.getIpAddress(request));
        yueLoginLogData.setMessage(result.getMessage());
        yueLoginLogData.setSuccess(true);
        yueLoginLogData.setCode(result.getCode());
        this.loginLogService.save(yueLoginLogData);
    }

    @AfterThrowing(value="YueLoginLogCut()", throwing="e")
    public void loginLogThrow(JoinPoint point, ResponseException e) {
        Object[] objects = point.getArgs();
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        LoginLog yueLoginLogData = new LoginLog();
        LoginRequest loginRequest = (LoginRequest)objects[0];
        yueLoginLogData.setIp(this.httpRequestIpUtils.getIpAddress(request));
        yueLoginLogData.setAccount(loginRequest.getAccount());
        yueLoginLogData.setMessage(e.getMessage());
        yueLoginLogData.setSuccess(false);
        yueLoginLogData.setCode(e.getCode());
        this.loginLogService.save(yueLoginLogData);
    }

    @Before(value="@annotation(log)")
    public void systemLogin(JoinPoint point, Log log) {
        if (this.basicDataRepository.existsByIsLogIsTrue().booleanValue()) {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            SystemLog systemLog = new SystemLog();
            LoginUser yueLoginUser = this.jwtUtils.getLoginUser();
            systemLog.setAccount(yueLoginUser.getAccount());
            systemLog.setIp(this.httpRequestIpUtils.getIpAddress(request));
            systemLog.setContent(log.value());
            this.yueSystemLogDataService.save(systemLog);
        }
    }
}

