/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.asp.intercept;

import cn.xisoil.asp.intercept.IpInterceptor;
import cn.xisoil.config.token.JwtInterceptor;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class MyInterceptorConfig
implements WebMvcConfigurer {
    @Autowired
    private JwtInterceptor jwtInterceptor;
    @Autowired
    private IpInterceptor ipInterceptor;

    public void addInterceptors(InterceptorRegistry registry) {
        ArrayList<String> pathPatterns = new ArrayList<String>();
        pathPatterns.add("/manage/**");
        ArrayList<String> excludePathPatterns = new ArrayList<String>();
        excludePathPatterns.add("/manage/auth/**");
        excludePathPatterns.add("/manage/system/basic");
        excludePathPatterns.add("/manage/utils/upload");
        excludePathPatterns.add("/manage/pay/notifyUrl");
        excludePathPatterns.add("/manage/analysis/**");
        registry.addInterceptor((HandlerInterceptor)this.jwtInterceptor).addPathPatterns(pathPatterns).excludePathPatterns(excludePathPatterns);
        registry.addInterceptor((HandlerInterceptor)this.ipInterceptor).addPathPatterns(new String[]{"/**"});
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedHeaders(new String[]{"*"}).allowedMethods(new String[]{"*"}).allowedOrigins(new String[]{"*"});
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/upload/**"}).addResourceLocations(new String[]{"file:resources/upload/"});
    }
}

