/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.asp.intercept;

import cn.xisoil.annotation.intercept.IpIntercept;
import cn.xisoil.data.enums.HTTPCODE;
import cn.xisoil.exception.ErrorPageException;
import cn.xisoil.utils.HttpRequestIpUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
@Aspect
public class IpInterceptor
implements HandlerInterceptor {
    @Autowired
    private HttpRequestIpUtils httpRequestIpUtils;
    @Autowired
    private RedisTemplate<String, Serializable> redisCacheTemplate;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Before(value="@annotation(ipIntercept)")
    public void ipCut(JoinPoint point, IpIntercept ipIntercept) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String ip = this.httpRequestIpUtils.getIpAddress(request);
        Serializable serializable = (Serializable)this.redisCacheTemplate.opsForValue().get((Object)("SECURITY:ACCESS:" + ip));
        if (serializable == null) {
            this.redisCacheTemplate.opsForValue().set((Object)("SECURITY:ACCESS:" + ip), (Object)1, 60L, TimeUnit.SECONDS);
            return;
        } else {
            int count = (Integer)serializable + 1;
            if (count > 20) {
                this.saveLog(ip, "\u65f6\u95f4\u5185\u8bbf\u95ee\u6b21\u6570\u8fbe\u5230\u9608\u503c\uff1a20");
                try {
                    Serializable serializable1 = (Serializable)this.redisCacheTemplate.opsForValue().get((Object)"SECURITY:BASIC");
                    if (serializable1 == null) return;
                }
                catch (Exception exception) {}
                return;
            } else {
                this.redisCacheTemplate.opsForValue().set((Object)("SECURITY:ACCESS:" + ip), (Object)count, this.redisCacheTemplate.getExpire((Object)("SECURITY:ACCESS:" + ip), TimeUnit.SECONDS).longValue(), TimeUnit.SECONDS);
                {
                    // empty if block
                }
            }
        }
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Serializable serializable = (Serializable)this.redisCacheTemplate.opsForValue().get((Object)"SECURITY:BASIC");
        if (serializable == null) {
            return true;
        }
        String referer = request.getHeader("referer");
        String host = request.getServerName();
        if ("POST".equals(request.getMethod()) || "GET".equals(request.getMethod())) {
            if (referer == null) {
                return true;
            }
            URL url = null;
            try {
                url = new URL(referer);
            }
            catch (MalformedURLException e) {
                response.setStatus(HTTPCODE.NOTFOUND.getCode().intValue());
            }
            if (!host.equals(url.getHost())) {
                response.setStatus(HTTPCODE.NOTFOUND.getCode().intValue());
                throw new ErrorPageException(401, "\u6d89\u5acc\u975e\u6cd5\u76d7\u94fe");
            }
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }

    private void saveLog(String ip, String message) {
    }
}

