package cn.xisoil.service.user.impl;

import cn.xisoil.config.token.JwtUtils;
import cn.xisoil.dao.user.UserRepository;
import cn.xisoil.data.pojo.user.LoginUser;
import cn.xisoil.data.result.R;
import cn.xisoil.data.to.SearchPageRequest;
import cn.xisoil.service.user.UserService;
import jakarta.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class UserServiceImpl implements UserService {

    @Autowired
    private JwtUtils jwtUtils;
    @Autowired
    private UserRepository userRepository;

    @Override
    public R<Page<LoginUser>> page(SearchPageRequest searchPageRequest) {
        LoginUser user=jwtUtils.getLoginUser();
        Pageable pageable = PageRequest.of(searchPageRequest.getPageNum(), searchPageRequest.getPageSize());
        Specification<LoginUser> sectionSpecification = (root, criteriaQuery, criteriaBuilder) -> {
            List<Predicate> predicates = new ArrayList();

            if (StringUtils.isNotBlank(searchPageRequest.getKeyword())){
                predicates.add(criteriaBuilder.like(root.get("account"),"%"+searchPageRequest.getKeyword()+"%"));
            }
            if (searchPageRequest.getOrderBy() != null) {
                criteriaQuery.orderBy(searchPageRequest.getOrderBy().getSortType().equals(Sort.Direction.DESC) ? criteriaBuilder.desc(root.get(searchPageRequest.getOrderBy().getColumn())) : criteriaBuilder.asc(root.get(searchPageRequest.getOrderBy().getColumn())));
            }
            return criteriaBuilder.and((Predicate[])predicates.toArray(new Predicate[0]));
        };
        Page<LoginUser> page = userRepository.findAll(sectionSpecification, pageable);
        return R.<Page<LoginUser>>builder().message("获取成功").success().data(page).build();
    }

    @Override
    public R<String> edit(LoginUser request) {
        LoginUser user=userRepository.findById(request.getId()).orElse(new LoginUser());
        if (!user.getPassword().equals(request.getPassword())){
            BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
            String encode = passwordEncoder.encode(request.getPassword()); //进行动态加盐加密
            request.setPassword(encode);
        }
        BeanUtils.copyProperties(request,user);
        userRepository.save(user);
        return R.<String>builder().success().message("修改成功").build();
    }

    @Override
    public R<String> add(LoginUser request) {
        LoginUser user=new LoginUser();
        BeanUtils.copyProperties(request,user);
        BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
        String encode = passwordEncoder.encode(request.getPassword()); //进行动态加盐加密
        user.setPassword(encode);
        userRepository.save(user);
        return R.<String>builder().success().message("修改成功").build();
    }


}
