package cn.xisoil.model.data;

import cn.xisoil.data.enums.ObjectColumnType;
import com.fasterxml.jackson.annotation.JsonInclude;


@JsonInclude(JsonInclude.Include.NON_NULL)
public class ModelColumn {

    //字段名
    private String column;
    //展示名称
    private String name;
    //字段类型
    private ObjectColumnType type;
    //是否可编辑
    private Boolean edit;
    //是否展示
    private Boolean show;
    //是否用户搜索
    private Boolean search;
    //是否可排序
    private Boolean comparable=false;
    //是否必填
    private Boolean required=false;
    //外键关联时，下拉选择框列表来源api（checkbox,radio,list需填写该字段）
    private String url;
    //输入提示
    private String placeholder;
    //分组名称
    private String group;


    public static Builder builder(){
        return new Builder();
    }


    private ModelColumn(Builder builder) {
        setColumn(builder.column);
        setName(builder.name);
        setType(builder.type);
        setEdit(builder.edit);
        setShow(builder.show);
        setSearch(builder.search);
        setComparable(builder.comparable);
        setRequired(builder.required);
        setUrl(builder.url);
        setPlaceholder(builder.placeholder);
        setGroup(builder.group);
    }

    public String getColumn() {
        return column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ObjectColumnType getType() {
        return type;
    }

    public void setType(ObjectColumnType type) {
        this.type = type;
    }

    public Boolean getEdit() {
        return edit;
    }

    public void setEdit(Boolean edit) {
        this.edit = edit;
    }

    public Boolean getShow() {
        return show;
    }

    public void setShow(Boolean show) {
        this.show = show;
    }

    public Boolean getSearch() {
        return search;
    }

    public void setSearch(Boolean search) {
        this.search = search;
    }

    public Boolean getComparable() {
        return comparable;
    }

    public void setComparable(Boolean comparable) {

        this.comparable = comparable;
    }

    public Boolean getRequired() {
        return required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPlaceholder() {
        return placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public String getGroup() {
        return group;
    }

    public void setGroup(String group) {
        this.group = group;
    }


    public static final class Builder {
        private String column;
        private String name;
        private ObjectColumnType type;
        private Boolean edit;
        private Boolean show;
        private Boolean search;
        private Boolean comparable;
        private Boolean required;
        private String url;
        private String placeholder;
        private String group;

        public Builder() {
        }

        public Builder column(String val) {
            column = val;
            return this;
        }

        public Builder name(String val) {
            name = val;
            return this;
        }

        public Builder type(ObjectColumnType val) {
            type = val;
            return this;
        }

        public Builder edit(Boolean val) {
            edit = val;
            return this;
        }

        public Builder show(Boolean val) {
            show = val;
            return this;
        }

        public Builder search(Boolean val) {
            search = val;
            return this;
        }

        public Builder comparable(Boolean val) {
            comparable = val;
            return this;
        }

        public Builder required(Boolean val) {
            required = val;
            return this;
        }

        public Builder url(String val) {
            url = val;
            return this;
        }

        public Builder placeholder(String val) {
            placeholder = val;
            return this;
        }

        public Builder group(String val) {
            group = val;
            return this;
        }

        public ModelColumn build() {
            return new ModelColumn(this);
        }
    }
}
