package cn.xisoil.data.pojo.role;


import cn.xisoil.annotation.model.CurdModel;
import cn.xisoil.annotation.model.CurdModelObject;
import cn.xisoil.data.enums.ObjectColumnType;
import cn.xisoil.data.to.StringConverters;
import jakarta.persistence.*;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Entity(name = "Role")
@Table(name = "v_role")
@EntityListeners(AuditingEntityListener.class)
@CurdModelObject(value = "角色管理")
public class Role {


    public Role(){

    }

    public Role(String title){
        this.title=title;
    }

    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy = "uuid")
    @Column(columnDefinition = "varchar(32)")
    private String id;

    @CurdModel("角色名称")
    private String title;

    @CreatedDate
    @CurdModel(value = "添加时间",type = ObjectColumnType.TIME,editor = false)
    private Date createTime;

    @CurdModel(value = "角色权限",type = ObjectColumnType.LISTMULTISELECT,url = "/permission/list")
    @Convert(converter = StringConverters.class)
    @Column(columnDefinition = "text(0)")
    private List<String> permissionIds=new ArrayList<>();

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public List<String> getPermissionIds() {
        return permissionIds;
    }

    public void setPermissionIds(List<String> permissionIds) {
        this.permissionIds = permissionIds;
    }
}
