package cn.xisoil.data.pojo.permission;


import cn.xisoil.annotation.model.CurdModel;
import cn.xisoil.annotation.model.CurdModelObject;
import cn.xisoil.data.enums.ObjectColumnType;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import jakarta.persistence.*;
import org.hibernate.annotations.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

@Entity(name = "Permission")
@Table(name = "permission")
@EntityListeners(AuditingEntityListener.class)
@CurdModelObject(value = "权限管理")
@FilterDef(name = "permissionChildren", parameters = {@ParamDef(name="ids",type=String.class)})
public class Permission {

    public Permission(){

    }
    public Permission(String title, String path, String ico){
        this.title=title;
        this.name=title;
        this.path=path;
        this.ico=ico;
    }

    public Permission(String title, String path){
        this.title=title;
        this.name=title;
        this.path=path;
    }

    @Id
    @GeneratedValue(generator="system-uuid")
    @GenericGenerator(name="system-uuid", strategy = "uuid")
    @Column(columnDefinition = "varchar(32)")
    private String id;

    @CurdModel(value = "所属父级",show = false,search = true,url = "/permission/list",type = ObjectColumnType.LIST)
    @Column(columnDefinition = "varchar(32)")
    private String parentId;

    @OneToMany(fetch = FetchType.EAGER)
    @JoinColumn(name = "parentId",columnDefinition = "varchar(32)")
    @JsonIgnoreProperties("children")
    @Fetch(FetchMode.SUBSELECT)
    @Filter(name = "permissionChildren", condition = " id in (:ids)   ")
    @OrderBy("comparable asc ")
    private Set<Permission> children=new HashSet<>();

    @CurdModel(value = "权限名称")
    private String name;

    private Date createTime;

    @Column(name = "`key`")
    private String key;

    @CurdModel(value = "排序",comparable = true,type = ObjectColumnType.NUMBER)
    private Integer comparable;

    private String title;

    public String getTitle() {
        return name;
    }

    @CurdModel(value = "权限地址")
    @Column(unique = true)
    private String path;

    @CurdModel(value = "权限图标",url = "/ico/list",type = ObjectColumnType.LIST)
    private String ico;

    public String getId() {
        return id;
    }

    public String getParentId() {
        return parentId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public void setChildren(Set<Permission> children) {
        this.children = children;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setComparable(Integer comparable) {
        this.comparable = comparable;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setIco(String ico) {
        this.ico = ico;
    }

    public Set<Permission> getChildren() {
        return children;
    }

    public String getName() {
        return name;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public String getKey() {
        return key;
    }

    public Integer getComparable() {
        return comparable;
    }

    public String getPath() {
        return path;
    }

    public String getIco() {
        return ico;
    }
}
