package cn.xisoil.dao.utils;

import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.transaction.annotation.Transactional;
import java.io.Serializable;
import java.util.List;

@NoRepositoryBean
public interface BatchRepository<T,ID extends Serializable> extends YueRepository<T,ID> {

    @Transactional
    void  saveAll(List<T> ts);



    @Transactional
    void deleteAll();

    @Transactional
    boolean deleteAllByIds(List<ID> ids);

    @Transactional
    boolean deleteAll(List<T> ts);

    List<T>findAllByIds(List<ID> ids);

}
