/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.utils.portkill;

import cn.xisoil.data.enums.EQUIPMENT;
import cn.xisoil.data.properties.YueProperties;
import jakarta.annotation.PostConstruct;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortKillConfig {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private YueProperties yueProperties;

    @PostConstruct
    public void init() {
        if (EQUIPMENT.windows.equals((Object)this.yueProperties.getEquipment())) {
            String res = this.exec(new String[]{"netstat", "-ano"});
            if (StringUtils.isNotBlank((CharSequence)res)) {
                this.logger.warn("\u7aef\u53e3\u5360\u7528\uff01\uff01\uff01\uff01\u62b9\u6740\uff01\uff01\uff01\uff01");
                String pid = res.substring(res.lastIndexOf("LISTENING") + 9);
                this.exec(new String[]{"taskkill", "-PID", pid, "-F"});
                this.logger.info("{}\u5df2\u62b9\u6740", (Object)pid);
            }
        } else {
            String res = this.exec(new String[]{"lsof", "-i:" + this.yueProperties.getPort()});
            if (StringUtils.isNotBlank((CharSequence)res)) {
                this.logger.warn("\u7aef\u53e3\u5360\u7528\uff01\uff01\uff01\uff01\u62b9\u6740\uff01\uff01\uff01\uff01");
                ArrayList<String> list = new ArrayList<String>(List.of(res.split("\\D+")));
                list.remove("");
                String pid = (String)list.get(0);
                this.exec(new String[]{"kill", "-9", pid});
                this.logger.info("{}\u5df2\u62b9\u6740", (Object)pid);
            }
        }
    }

    public String exec(String[] para) {
        try {
            String line;
            Process proc = Runtime.getRuntime().exec(para);
            BufferedReader in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            StringBuilder rs = new StringBuilder();
            while ((line = in.readLine()) != null) {
                if (!line.contains(this.yueProperties.getPort()) || this.yueProperties.getEquipment().equals((Object)EQUIPMENT.windows) && !line.contains(" LISTENING")) continue;
                rs.append(line.replace(" ", ""));
                break;
            }
            in.close();
            proc.waitFor();
            return rs.toString();
        }
        catch (Exception e) {
            this.logger.warn("\u554a\u8fd9\uff0c\u7cfb\u7edf\u73af\u5883\u9519\u8bef\uff0c\u65e0\u6cd5\u62b9\u6740\uff01\uff01\uff01\uff01");
            return "";
        }
    }
}

