/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.utils;

import java.lang.annotation.Annotation;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class SpringContextUtils
implements BeanFactoryAware,
ApplicationContextAware {
    private static DefaultListableBeanFactory listableBeanFactory;
    protected ApplicationContext applicationContext;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        listableBeanFactory = (DefaultListableBeanFactory)beanFactory;
        listableBeanFactory.setAllowBeanDefinitionOverriding(true);
    }

    public void registerSingleton(String beanName, Object object) {
        listableBeanFactory.registerSingleton(beanName, object);
    }

    public void destroySingleton(String beanName) {
        listableBeanFactory.destroySingleton(beanName);
    }

    public Object getBean(String beanName) {
        if (this.containsBean(beanName)) {
            return listableBeanFactory.getBean(beanName);
        }
        return null;
    }

    public String[] getBeanNamesForType(Class<?> clazz) {
        return listableBeanFactory.getBeanNamesForType(clazz);
    }

    public <T> List<T> getBeansForType(Class<T> clazz) {
        String[] beanNames = listableBeanFactory.getBeanNamesForType(clazz);
        LinkedList<Object> tList = new LinkedList<Object>();
        for (String beanName : beanNames) {
            tList.add(listableBeanFactory.getBean(beanName, clazz));
        }
        return tList;
    }

    public <T> T getBeanForType(Class<T> clazz) {
        return (T)listableBeanFactory.getBeanProvider(clazz).getIfAvailable();
    }

    public <T extends Annotation> Map<String, Object> getBeansWithAnnotation(Class<T> tClass) {
        return this.applicationContext.getBeansWithAnnotation(tClass);
    }

    public boolean containsBean(String beanName) {
        return listableBeanFactory.containsBean(beanName);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

