/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.utils;

import cn.xisoil.annotation.log.Log;
import cn.xisoil.config.token.JwtUtils;
import cn.xisoil.data.pojo.log.SystemLog;
import cn.xisoil.data.pojo.user.LoginUser;
import cn.xisoil.model.service.model.ModelService;
import cn.xisoil.service.log.LoginLogService;
import cn.xisoil.service.log.YueSystemLogDataService;
import cn.xisoil.utils.HttpRequestIpUtils;
import jakarta.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@Aspect
public class AspLogAspect {
    @Autowired
    private HttpRequestIpUtils httpRequestIpUtils;
    @Autowired
    private LoginLogService loginLogService;
    @Autowired
    private JwtUtils jwtUtils;
    @Autowired
    private ModelService modelService;
    @Autowired
    private YueSystemLogDataService yueSystemLogDataService;

    @Pointcut(value="@annotation(cn.xisoil.annotation.Log)")
    public void YueSystemLogCut() {
    }

    @Before(value="@annotation(log)")
    public void systemLogin(JoinPoint point, Log log) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        SystemLog systemLog = new SystemLog();
        LoginUser yueLoginUser = this.jwtUtils.getLoginUser();
        systemLog.setAccount(yueLoginUser.getAccount());
        systemLog.setIp(this.httpRequestIpUtils.getIpAddress(request));
        systemLog.setContent(log.value());
        this.yueSystemLogDataService.save(systemLog);
    }
}

