/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.model.service.list;

import cn.xisoil.dao.YueRepository;
import cn.xisoil.data.result.R;
import cn.xisoil.data.to.ListStringRequest;
import cn.xisoil.data.to.SearchPageRequest;
import cn.xisoil.exception.NormalException;
import cn.xisoil.model.data.ModelColumn;
import cn.xisoil.model.service.model.ModelService;
import cn.xisoil.utils.GenericObject;
import cn.xisoil.utils.SpringContextUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.transaction.Transactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;

public class CurdDaoServiceImpl<T, V extends YueRepository<T, String>>
extends GenericObject<T> {
    @Autowired
    private V repository;
    @Autowired
    private SpringContextUtils springContextUtils;
    @Autowired
    private ModelService modelService;

    @Transactional
    public R<String> delete(ListStringRequest request) {
        this.repository.deleteAllByIdIn(request.getIds());
        return R.builder().message("\u5220\u9664\u6210\u529f").success().build();
    }

    public R<String> edit(T request) {
        Object t = this.repository.findById((Object)JSONObject.parseObject((String)JSON.toJSONString(request)).getString("id")).orElseThrow(() -> new NormalException("\u6570\u636e\u4e0d\u5b58\u5728"));
        BeanUtils.copyProperties(request, t);
        this.repository.save(t);
        return R.builder().success().message("\u4fee\u6539\u6210\u529f").build();
    }

    public R<String> add(T request) {
        Object t = this.object();
        BeanUtils.copyProperties(request, t);
        this.repository.save(t);
        return R.builder().success().message("\u6dfb\u52a0\u6210\u529f").build();
    }

    public R<Page<T>> page(SearchPageRequest searchPageRequest) {
        PageRequest pageable = PageRequest.of((int)searchPageRequest.getPageNum(), (int)searchPageRequest.getPageSize());
        Specification & Serializable sectionSpecification = (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            List<String> searchColumns = this.modelService.getSearchColumn(this.getGenericClass());
            if (StringUtils.isNotBlank((CharSequence)searchPageRequest.getKeyword()) && !searchColumns.isEmpty()) {
                ArrayList searchPredicates = new ArrayList();
                searchColumns.forEach(s -> searchPredicates.add(criteriaBuilder.or(new Predicate[]{criteriaBuilder.like((Expression)root.get(s), "%" + searchPageRequest.getKeyword() + "%")})));
                predicates.add(criteriaBuilder.or(searchPredicates.toArray(new Predicate[0])));
            }
            List<ModelColumn> searchListColumns = this.modelService.getListSearchColumn(this.getGenericClass());
            searchListColumns.forEach(searchListColumn -> {
                if (StringUtils.isNotBlank((CharSequence)searchPageRequest.getString(searchListColumn.getColumn()))) {
                    predicates.add(criteriaBuilder.equal(root.get(searchListColumn.getColumn()).as(String.class), searchPageRequest.get(searchListColumn.getColumn())));
                }
            });
            if (searchPageRequest.getOrderBy() != null && StringUtils.isNotBlank((CharSequence)searchPageRequest.getOrderBy().getColumn())) {
                criteriaQuery.orderBy(new Order[]{searchPageRequest.getOrderBy().getSortType().equals((Object)Sort.Direction.DESC) ? criteriaBuilder.desc((Expression)root.get(searchPageRequest.getOrderBy().getColumn())) : criteriaBuilder.asc((Expression)root.get(searchPageRequest.getOrderBy().getColumn()))});
            }
            return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        };
        Page page = this.repository.findAll((Specification)sectionSpecification, (Pageable)pageable);
        return R.builder().message("\u83b7\u53d6\u6210\u529f").success().data(page).build();
    }

    public R<List<T>> list() {
        List list = this.repository.findAll();
        return R.builder().success().message("\u83b7\u53d6\u6210\u529f").data(list).build();
    }

    public R<List<T>> search(String keyword, String id) {
        Specification & Serializable sectionSpecification = (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            List<String> searchColumns = this.modelService.getSearchColumn(this.getGenericClass());
            if (StringUtils.isNotBlank((CharSequence)keyword) && !searchColumns.isEmpty()) {
                ArrayList searchPredicates = new ArrayList();
                searchColumns.forEach(s -> searchPredicates.add(criteriaBuilder.or(new Predicate[]{criteriaBuilder.like((Expression)root.get(s), "%" + keyword + "%")})));
                predicates.add(criteriaBuilder.or(searchPredicates.toArray(new Predicate[0])));
            }
            if (StringUtils.isNotBlank((CharSequence)id)) {
                predicates.add(criteriaBuilder.equal((Expression)root.get("id"), (Object)id));
            }
            return criteriaBuilder.or(predicates.toArray(new Predicate[0]));
        };
        List list = this.repository.findAll((Specification)sectionSpecification);
        return R.builder().message("\u83b7\u53d6\u6210\u529f").success().data(list).build();
    }

    public R<T> get(String id) {
        Object t = this.repository.findById((Object)id).orElseThrow(() -> new NormalException("\u6570\u636e\u4e0d\u5b58\u5728"));
        return R.builder().success().data(t).message("\u83b7\u53d6\u6210\u529f").build();
    }
}

