/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.filter;

import cn.xisoil.annotation.filter.Idempotent;
import cn.xisoil.data.enums.HTTPCODE;
import cn.xisoil.exception.ResponseException;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;

@Component
@Aspect
public class IdempotentAspect {
    private static final String KEY_TEMPLATE = "IDEMPOTENT:";
    @Autowired
    private RedisTemplate<String, Serializable> redisTemplate;

    @Pointcut(value="@annotation(cn.xisoil.annotation.filter.Idempotent)")
    public void executeIdempotent() {
    }

    @Around(value="executeIdempotent()")
    public Object around(ProceedingJoinPoint jPoint) throws Throwable {
        Method method = ((MethodSignature)jPoint.getSignature()).getMethod();
        Idempotent idempotent = method.getAnnotation(Idempotent.class);
        String key = idempotent.key() + "_" + IdempotentAspect.generate(method, jPoint.getArgs());
        if (Boolean.TRUE.equals(this.redisTemplate.hasKey((Object)(KEY_TEMPLATE + key)))) {
            throw new ResponseException(HTTPCODE.ACCEPTED, idempotent.message());
        }
        this.redisTemplate.opsForValue().setIfAbsent((Object)(KEY_TEMPLATE + key), (Object)idempotent.key(), (long)idempotent.timeout(), TimeUnit.SECONDS);
        return jPoint.proceed();
    }

    public static String generate(Method method, Object ... args) {
        StringBuilder stringBuilder = new StringBuilder(method.toString());
        for (Object arg : args) {
            stringBuilder.append(IdempotentAspect.toString(arg));
        }
        return IdempotentAspect.md5(stringBuilder.toString());
    }

    public static String toString(Object obj) {
        if (obj == null || obj instanceof BindingResult || obj instanceof HttpServletRequest || obj instanceof Model) {
            return "-";
        }
        return JSONObject.toJSONString((Object)obj, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
    }

    public static String md5(String str) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            MessageDigest mDigest = MessageDigest.getInstance("MD5");
            mDigest.update(str.getBytes());
            byte[] b = mDigest.digest();
            byte j = 0;
            int max = b.length;
            for (int i = 0; i < max; ++i) {
                j = b[i];
                if (j < 0) {
                    i += 256;
                } else if (j < 16) {
                    stringBuilder.append(0);
                }
                stringBuilder.append(Integer.toHexString(j));
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return stringBuilder.toString();
    }
}

