/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.data.properties;

import cn.hutool.core.date.DateUtil;
import cn.xisoil.data.enums.EQUIPMENT;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="yue", ignoreUnknownFields=true, ignoreInvalidFields=true)
public class YueProperties {
    @Value(value="${server.port}")
    private String port;
    private final Date startTime = new Date();
    private EQUIPMENT equipment = EQUIPMENT.linux;

    public void setEquipment(EQUIPMENT equipment) {
        this.equipment = equipment;
    }

    public EQUIPMENT getEquipment() {
        return this.equipment;
    }

    public String getPort() {
        return this.port;
    }

    public String getRunTime() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime after = LocalDateTime.ofInstant(this.startTime.toInstant(), ZoneId.systemDefault());
        return DateUtil.formatBetween((long)ChronoUnit.MILLIS.between(after, now));
    }

    public Date getStartTime() {
        return this.startTime;
    }
}

