/*
 * Decompiled with CFR 0.152.
 */
package cn.xisoil.config.token;

import cn.xisoil.data.enums.HTTPCODE;
import cn.xisoil.data.pojo.user.LoginUser;
import cn.xisoil.exception.ResponseException;
import com.alibaba.fastjson.JSON;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.Hashtable;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class JwtUtils {
    private static final String signingKey = "java666";

    public LoginUser getLoginUser() {
        HttpServletRequest httpServletRequest = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String token = httpServletRequest.getHeader("token");
        if (token != null) {
            JwtParser jwtParser = Jwts.parser();
            jwtParser.setSigningKey(signingKey);
            try {
                Jws claimsJws = jwtParser.parseClaimsJws(token);
                Claims body = (Claims)claimsJws.getBody();
                String subject = body.getSubject();
                String key = (String)body.get("key", String.class);
                LoginUser user = (LoginUser)JSON.parseObject((String)key, LoginUser.class);
                return user;
            }
            catch (Exception e) {
                throw new ResponseException(HTTPCODE.UNAUTHORIZED);
            }
        }
        throw new ResponseException(HTTPCODE.UNAUTHORIZED);
    }

    public String jwt(LoginUser user) {
        String userJson = JSON.toJSONString((Object)user);
        JwtBuilder jwtBuilder = Jwts.builder();
        Hashtable<String, String> map = new Hashtable<String, String>();
        map.put("key", userJson);
        String token = jwtBuilder.setSubject(user.getNickname()).setIssuedAt(new Date()).setId(user.getId()).setClaims(map).setExpiration(new Date(System.currentTimeMillis() + 0x6DDD00L)).signWith(SignatureAlgorithm.HS256, signingKey).compact();
        return token;
    }
}

